/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.core;

import com.hanshow.cdi.core.BatchRecord;
import com.hanshow.cdi.core.UploadedFile;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.cdi.service.CdiService;
import com.hanshow.cdi.service.StoreService;
import com.hanshow.cdi.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BatchCreator {
    private static final List<Map<String, Object>> EMPTY_LIST = new ArrayList<Map<String, Object>>(0);
    private List<Map<String, Object>> cache;
    private int max;
    private Map<String, Map<String, CdiProperties.Field>> taskFieldsNamesMap;
    private UploadedFile uploadedFile;
    private int batchNum;
    private int itemsNum;
    private Map<String, Map<String, CdiProperties.Store>> taskServerStoreCodeMap;
    Map<String, Map<String, String>> taskServerUrlMap;
    private CdiService cdiService;
    private StoreService storeService;

    public BatchCreator(UploadedFile uploadedFile, CdiService cdiService, int max, Map<String, Map<String, CdiProperties.Field>> taskFieldsNamesMap, Map<String, Map<String, CdiProperties.Store>> taskServerStoreCodeMap, Map<String, Map<String, String>> taskServerUrlMap, StoreService storeService) {
        this.cdiService = cdiService;
        this.storeService = storeService;
        this.max = max;
        this.cache = new LinkedList<Map<String, Object>>();
        this.taskFieldsNamesMap = taskFieldsNamesMap;
        this.uploadedFile = uploadedFile;
        this.taskServerStoreCodeMap = taskServerStoreCodeMap;
        this.taskServerUrlMap = taskServerUrlMap;
        this.batchNum = 0;
        this.itemsNum = 0;
    }

    public void add(Map<String, Object> item) {
        this.cache.add(this.convertFieldsNames(item));
        ++this.itemsNum;
        if (this.max > 0 && this.cache.size() >= this.max) {
            this.insertBatchRecord(this.cache);
            this.cache.clear();
        }
    }

    public void flush() {
        if (this.cache.size() > 0) {
            this.insertBatchRecord(this.cache);
            this.cache.clear();
        }
        if (this.batchNum == 0) {
            this.insertBatchRecord(EMPTY_LIST);
        }
    }

    private void insertBatchRecord(List<Map<String, Object>> items) {
        String fileName = this.uploadedFile.getFileName();
        String batchId = String.format("%s-%s016x", fileName, Utils.createId());
        HashMap<String, Object> batch = new HashMap<String, Object>();
        batch.put("storeCode", this.uploadedFile.getStoreCode());
        batch.put("customerStoreCode", this.uploadedFile.getCustomerStoreCode());
        batch.put("batchSize", items.size());
        batch.put("batchNo", batchId);
        batch.put("items", items);
        if (this.taskServerStoreCodeMap.get(this.uploadedFile.getTaskName()).containsKey(this.uploadedFile.getStoreCode()) && this.taskServerStoreCodeMap.get(this.uploadedFile.getTaskName()).get(this.uploadedFile.getStoreCode()).getIntegrationUrl().length > 0) {
            int i = 0;
            for (String url : this.taskServerStoreCodeMap.get(this.uploadedFile.getTaskName()).get(this.uploadedFile.getStoreCode()).getIntegrationUrl()) {
                this.createRecord(batch, batchId, i, url, "");
                ++i;
            }
        } else {
            int i = 0;
            for (Map.Entry<String, String> url : this.taskServerUrlMap.get(this.uploadedFile.getTaskName()).entrySet()) {
                this.createRecord(batch, batchId, i, url.getKey(), url.getValue());
                ++i;
            }
        }
        ++this.batchNum;
    }

    private void createRecord(Map<String, Object> batch, String batchId, int i, String serverUrl, String callbackUrl) {
        try {
            batch.put("callbackUrl", callbackUrl);
            String json = Utils.toJsonString(batch);
            BatchRecord record = new BatchRecord();
            record.setBatchId(batchId + i);
            record.setData(json);
            if (serverUrl.contains("shopweb")) {
                record.setServerUrl(serverUrl);
            } else {
                record.setServerUrl(serverUrl + "/" + this.uploadedFile.getCustomerStoreCode() + "/" + this.uploadedFile.getStoreCode());
            }
            record.setStoreCode(this.uploadedFile.getStoreCode() + "-" + i);
            record.setCustomerStoreCode(this.uploadedFile.getCustomerStoreCode());
            record.setTaskName(this.uploadedFile.getTaskName());
            this.cdiService.insertBatch(record);
            record.setAmount(batch.get("batchSize").toString());
            this.storeService.insertHistoryRecord(record);
        }
        catch (Exception e) {
            throw new RuntimeException("serialize batch data to JSON failed.", e);
        }
    }

    private Map<String, Object> convertFieldsNames(Map<String, Object> src) {
        LinkedHashMap<String, Object> dst = new LinkedHashMap<String, Object>();
        this.taskFieldsNamesMap.get(this.uploadedFile.getTaskName()).forEach((key, value) -> dst.put((String)key, src.get(value.getCustomer())));
        dst.put("storeCode", src.get("storeCode"));
        dst.put("customerStoreCode", src.get("customerStoreCode"));
        return dst;
    }

    public int getBatchNum() {
        return this.batchNum;
    }

    public int getItemsNum() {
        return this.itemsNum;
    }
}

