/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.core;

import com.hanshow.cdi.io.Line;
import com.hanshow.cdi.io.LineReader;
import com.hanshow.cdi.util.JsonUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class FileLineSorterByBucketAndMerge {
    private static String INPUT_FILE_PATH = "F:\\test\\intsmart\\cdi-sort\\random2-80w";
    private static String OUTPUT_FILE_PATH = "F:\\test\\intsmart\\cdi-sort\\random2-80w-output-%s.txt";
    private static int SORT_COLUMN_INDEX = 1;

    public static void main(String[] args) throws IOException, InterruptedException {
        int i;
        int threadsNum = 1;
        Thread[] threads = new Thread[threadsNum];
        long allBegin = System.currentTimeMillis();
        for (i = 0; i < threadsNum; ++i) {
            int finalI = i;
            threads[i] = new Thread(() -> {
                long begin = System.currentTimeMillis();
                List<File> chunkFiles = null;
                try {
                    chunkFiles = FileLineSorterByBucketAndMerge.createChunkFiles(INPUT_FILE_PATH, 2000);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                long chunkTime = System.currentTimeMillis();
                System.out.println("chunk complete. " + finalI + "  " + (chunkTime - begin));
                for (File chunkFile : chunkFiles) {
                    try {
                        FileLineSorterByBucketAndMerge.sortChunkFile(chunkFile, SORT_COLUMN_INDEX);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                long sortChunkTime = System.currentTimeMillis();
                System.out.println("Sort chunk complete. " + finalI + "  " + (sortChunkTime - chunkTime));
                try {
                    FileLineSorterByBucketAndMerge.mergeSortedChunkFiles(chunkFiles, SORT_COLUMN_INDEX, String.format(OUTPUT_FILE_PATH, finalI + ""));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                long mergeChunkTime = System.currentTimeMillis();
                for (File chunkFile : chunkFiles) {
                    chunkFile.delete();
                }
                System.out.println("Sort complete. " + finalI + "  " + (mergeChunkTime - sortChunkTime));
            });
        }
        for (i = 0; i < threadsNum; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threadsNum; ++i) {
            threads[i].join();
        }
        System.out.println("all cost : " + (System.currentTimeMillis() - allBegin));
    }

    public static List<File> createChunkFiles(String inputFilePath, int chunkSize) throws IOException {
        ArrayList<File> chunkFiles = new ArrayList<File>();
        try (LineReader reader = new LineReader(new File(inputFilePath));){
            List<Object> lines;
            while ((lines = FileLineSorterByBucketAndMerge.readLines(reader, chunkSize)) != null) {
                File chunkFile = File.createTempFile("chunk_", ".tmp");
                try (PrintWriter writer = new PrintWriter(new FileWriter(chunkFile));){
                    lines.forEach(writer::println);
                    writer.flush();
                }
                chunkFiles.add(chunkFile);
            }
        }
        return chunkFiles;
    }

    public static void sortChunkFile(File chunkFile, int columnIndex) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(chunkFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        lines.sort((o1, o2) -> {
            Map m1 = new HashMap();
            Map m2 = new HashMap();
            try {
                m1 = JsonUtils.readJson(o1, Map.class);
                m2 = JsonUtils.readJson(o2, Map.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return m1.get("ProdID").toString().compareTo(m2.get("ProdID").toString());
        });
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(chunkFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }

    public static void mergeSortedChunkFiles(List<File> chunkFiles, int columnIndex, String outputFilePath) throws IOException {
        PriorityQueue<ChunkReader> minHeap = new PriorityQueue<ChunkReader>(Comparator.comparing(s -> ((ChunkReader)s).currentLineWithKey));
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(outputFilePath, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
            for (File chunkFile : chunkFiles) {
                ChunkReader reader = new ChunkReader(chunkFile, columnIndex);
                if (reader.existNext()) {
                    minHeap.offer(reader);
                    continue;
                }
                reader.close();
            }
            while (!minHeap.isEmpty()) {
                ChunkReader reader = minHeap.poll();
                writer.write(reader.currentLineWithKey.substring(reader.currentLineWithKey.indexOf(",") + 1));
                writer.newLine();
                if (reader.hasNext()) {
                    minHeap.offer(reader);
                    continue;
                }
                reader.close();
            }
        }
    }

    private static <T> List<T> readLines(LineReader reader, int maxLines) {
        Line line;
        ArrayList<String> lines = null;
        for (int num = 0; num < maxLines && (line = reader.readLine()) != null; ++num) {
            if (lines == null) {
                lines = new ArrayList<String>();
            }
            lines.add(line.getText());
        }
        return lines;
    }

    private static class ChunkReader
    implements Closeable {
        private final BufferedReader reader;
        private final int columnIndex;
        private String currentLineWithKey;

        public ChunkReader(File chunkFile, int columnIndex) throws IOException {
            this.reader = new BufferedReader(new InputStreamReader(Files.newInputStream(chunkFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            this.columnIndex = columnIndex;
            this.currentLineWithKey = this.readNextLine();
        }

        public boolean existNext() throws IOException {
            return this.currentLineWithKey != null;
        }

        public boolean hasNext() throws IOException {
            if (this.currentLineWithKey == null) {
                return false;
            }
            String nextLineWithKey = this.readNextLine();
            if (nextLineWithKey != null) {
                this.currentLineWithKey = nextLineWithKey;
                return true;
            }
            return false;
        }

        public String getCurrentLine() {
            return this.currentLineWithKey.substring(this.columnIndex + 1);
        }

        private String readNextLine() throws IOException {
            String line = this.reader.readLine();
            if (line == null) {
                this.close();
                return null;
            }
            Map map = JsonUtils.readJson(line, Map.class);
            String key = (String)map.get("ProdID");
            return key + "," + line;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

