/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.core;

import com.hanshow.cdi.common.GetStoreCodeTypeEnum;
import com.hanshow.cdi.common.ReloadTypeEnum;
import com.hanshow.cdi.core.IntegrationMode;
import com.hanshow.cdi.core.PathHelper;
import com.hanshow.cdi.core.ServerSender;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.cdi.service.CdiService;
import com.hanshow.cdi.service.StoreService;
import com.hanshow.cdi.sftp.UserManager;
import com.hanshow.cdi.util.AESUtils;
import com.hanshow.cdi.util.OkHttpClientWrap;
import com.hanshow.cdi.util.OkHttpsCertClientWrap;
import com.hanshow.cdi.util.OkHttpsClientWrap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;

public class GenericCdiServerContext
extends CdiProperties {
    private static final Logger log = LogManager.getLogger(GenericCdiServerContext.class);
    private File rootDir;
    private File msgFileDir;
    private File msgDir;
    private File temporaryDir;
    private File logDir;
    private File backupDir;
    private File uploadDir;
    private File downloadDir;
    private Locale locale;
    private TimeZone timeZone;
    private InetSocketAddress cdiFtpAddress;
    private File ftpUsersPropertiesFile;
    private InetSocketAddress ftpCustomerServerAddress;
    private File ftpCustomerUsersPropertiesFile;
    private InetSocketAddress sftpCustomerServerAddress;
    private File sftpCustomerUsersPropertiesFile;
    private UserManager userManager;
    private String integrationHome;
    private Map<String, String> taskJsonRecordKeys;
    private Map<String, Map<String, CdiProperties.Field>> taskServerFieldsNameMap;
    private Map<String, Map<String, CdiProperties.Field>> taskCustomerPrismartFieldsMap;
    private Map<String, Map<String, CdiProperties.Store>> taskServerStoreCodeMap;
    private Map<String, Map<String, String>> taskServerTransformStoreCodeMap;
    private Map<String, Map<String, String>> taskServerUrlMap;
    private Map<String, Map<String, SimpleDateFormat>> taskFieldsDateFormat;
    private Map<String, String> taskFtpServerUserMap;
    private Map<String, String> taskSftpServerUserMap;
    private Set<String> sftpUsers;
    private CdiService cdiService;
    private StoreService storeService;
    private Map<String, Map<String, CdiProperties.Store>> taskStoreMap;
    private Map<String, CdiProperties.Task> taskMap;
    private OkHttpClientWrap okHttpClientWrap;
    private OkHttpsClientWrap okHttpsClientWrap;
    private Map<String, OkHttpsCertClientWrap> okHttpsCertClientWrapMap;
    private Map<String, String> taskLimit;
    private Map<String, Map<String, Boolean>> useCertificateUrlMap;
    private ServerSender serverSender;
    private boolean ftpServer = false;
    private boolean sftpServer = false;
    private boolean cdiSwitch = false;
    private boolean quickSort = false;
    private int serverNum = 0;
    private Map<String, File> taskLocalDirMap;
    private CdiProperties cdiProperties;

    public void reload(CdiProperties cdiProperties, ReloadTypeEnum reloadTypeEnum, String taskName) {
        this.cdiProperties = cdiProperties;
        this.setCdiSystem(new CdiProperties.CdiSystem());
        this.setTask(new ArrayList<CdiProperties.Task>());
        BeanUtils.copyProperties((Object)cdiProperties, (Object)this);
        BeanUtils.copyProperties((Object)cdiProperties.getCdiSystem(), (Object)this.getCdiSystem());
        this.serverNum = 0;
        if (reloadTypeEnum == ReloadTypeEnum.SYSTEM) {
            this.locale = new Locale(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getLocale(), "zh_CN"));
            this.timeZone = TimeZone.getTimeZone(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getTimeZone(), "Asia/Shanghai"));
            cdiProperties.getCdiSystem().setCharset(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getCharset(), "UTF-8"));
            this.integrationHome = System.getProperty("integration.home");
            this.getCdiSystem().setMaxNumPerPost(GenericCdiServerContext.defaultInt(cdiProperties.getCdiSystem().getMaxNumPerPost(), 1000));
            this.getCdiSystem().setDataFileKeepingDays(GenericCdiServerContext.defaultInt(cdiProperties.getCdiSystem().getDataFileKeepingDays(), 7));
            this.getCdiSystem().setCdiFtpSwitch(GenericCdiServerContext.defaultBoolean(cdiProperties.getCdiSystem().isCdiFtpSwitch(), false));
            if (this.getCdiSystem().isCdiFtpSwitch()) {
                this.getCdiSystem().setCdiFtpHost(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getCdiFtpHost(), "127.0.0.1"));
                if (cdiProperties.getCdiSystem().getCdiFtpPort() != null && !"".equals(cdiProperties.getCdiSystem().getCdiFtpHost())) {
                    this.getCdiSystem().setCdiFtpPort(GenericCdiServerContext.defaultInt(this.getCdiSystem().getCdiFtpPort(), 21021));
                    this.cdiFtpAddress = new InetSocketAddress(this.getCdiSystem().getCdiFtpHost(), (int)this.getCdiSystem().getCdiFtpPort());
                    log.info("create ftpServer, the host is : [{}], the port is : [{}]", (Object)this.getCdiSystem().getCdiFtpHost(), (Object)this.getCdiSystem().getCdiFtpPort());
                }
            }
            if (this.cdiFtpAddress != null) {
                this.initializeFtpUsersPropertiesFile(this.rootDir);
            }
            this.okHttpClientWrap = new OkHttpClientWrap(this.getCdiSystem().getTimeout());
            this.okHttpsClientWrap = new OkHttpsClientWrap(this.getCdiSystem().getTimeout());
            this.serverSender.setOkHttpClientWrap(this.okHttpClientWrap);
            this.serverSender.setOkHttpsClientWrap(this.okHttpsClientWrap);
            this.serverSender.setUseCertificateUrlMap(this.useCertificateUrlMap);
        } else if (reloadTypeEnum == ReloadTypeEnum.ADD_UPDATE) {
            this.ftpServer = false;
            this.sftpServer = false;
            for (CdiProperties.Task task : this.getTask()) {
                if (task.getTaskName().equals(taskName)) {
                    if (task.getServerUrls() == null || task.getServerUrls().isEmpty()) {
                        log.warn("Cannot find Server integration URL in task : {}, {}", (Object)task.getTaskName(), (Object)task);
                    }
                    this.taskServerFieldsNameMap.put(task.getTaskName(), task.getFields().stream().collect(Collectors.toMap(CdiProperties.Field::getHanshow, Function.identity(), (u, v) -> {
                        throw new IllegalStateException(String.format("Duplicate key %s", u));
                    }, LinkedHashMap::new)));
                    if (this.taskServerFieldsNameMap != null && !this.taskServerFieldsNameMap.get(task.getTaskName()).containsKey("sku")) {
                        throw new IllegalArgumentException("the filed not contains 'sku'");
                    }
                    if (this.taskServerFieldsNameMap.get(task.getTaskName()) != null && this.taskServerFieldsNameMap.get(task.getTaskName()).containsKey("sku")) {
                        this.taskJsonRecordKeys.put(task.getTaskName(), this.taskServerFieldsNameMap.get(task.getTaskName()).get("sku").getCustomer());
                    }
                    this.taskFieldsDateFormat.put(task.getTaskName(), task.getFields().stream().filter(field -> StringUtils.isNotBlank((String)field.getDateFormat())).collect(Collectors.toMap(CdiProperties.Field::getCustomer, value -> new SimpleDateFormat(value.getDateFormat()))));
                    this.taskCustomerPrismartFieldsMap.put(task.getTaskName(), task.getFields().stream().collect(Collectors.toMap(CdiProperties.Field::getCustomer, Function.identity(), (u, v) -> {
                        throw new IllegalStateException(String.format("Duplicate key %s", u));
                    }, LinkedHashMap::new)));
                    this.taskServerStoreCodeMap.put(task.getTaskName(), task.getStores().stream().collect(Collectors.toMap(store -> StringUtils.isBlank((String)store.getHanshowStoreCode()) ? store.getStoreCode() : store.getHanshowStoreCode(), Function.identity(), (u, v) -> {
                        throw new IllegalStateException(String.format("Duplicate key %s", u));
                    }, LinkedHashMap::new)));
                    this.taskServerUrlMap.put(task.getTaskName(), task.getServerUrls().stream().collect(Collectors.toMap(CdiProperties.ServerUrl::getIntegrationUrl, CdiProperties.ServerUrl::getCallbackUrl, (u, v) -> {
                        throw new IllegalStateException(String.format("Duplicate key %s", u));
                    }, LinkedHashMap::new)));
                    this.taskServerTransformStoreCodeMap.put(task.getTaskName(), task.getStores().stream().collect(Collectors.toMap(CdiProperties.Store::getStoreCode, CdiProperties.Store::getHanshowStoreCode, (u, v) -> {
                        throw new IllegalStateException(String.format("Duplicate key %s", u));
                    }, LinkedHashMap::new)));
                    this.useCertificateUrlMap.put(task.getTaskName(), task.getServerUrls().stream().collect(Collectors.toMap(CdiProperties.ServerUrl::getIntegrationUrl, CdiProperties.ServerUrl::getUseCertificate, (u, v) -> {
                        throw new IllegalStateException(String.format("Duplicate key %s", u));
                    }, LinkedHashMap::new)));
                    if (StringUtils.isNotBlank((String)task.getDatasource().getLocalDir())) {
                        this.taskLocalDirMap.put(task.getTaskName(), new File(task.getDatasource().getLocalDir()));
                        if (IntegrationMode.CLIENT_LOCAL.getName().equals(task.getIntegrationMode()) && this.taskServerStoreCodeMap != null && task.getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.ByDir.getType()) {
                            this.initFileDir(task.getTaskName());
                        } else if (IntegrationMode.CLIENT_FTP.getName().equals(task.getIntegrationMode()) || IntegrationMode.CLIENT_SFTP.getName().equals(task.getIntegrationMode())) {
                            this.taskLocalDirMap.put(task.getTaskName(), this.initializeDirectory(this.taskLocalDirMap.get(task.getTaskName()), GenericCdiServerContext.defaultString(task.getDatasource().getLocalDir(), "local")));
                            this.initFileDir(task.getTaskName());
                        }
                    }
                    this.taskMap.put(task.getTaskName(), task);
                }
                if (IntegrationMode.SERVER_FTP.getName().equals(task.getIntegrationMode())) {
                    this.getTaskFtpServerUserMap().put(task.getTaskName(), AESUtils.decrypt(task.getDatasource().getFtpServerPassword()));
                    this.ftpServer = true;
                    ++this.serverNum;
                }
                if (!IntegrationMode.SERVER_SFTP.getName().equals(task.getIntegrationMode())) continue;
                this.getTaskSftpServerUserMap().put(task.getTaskName(), AESUtils.decrypt(task.getDatasource().getSftpServerPassword()));
                this.sftpServer = true;
                ++this.serverNum;
            }
            this.initFileBakDir();
        } else if (reloadTypeEnum == ReloadTypeEnum.DELETE) {
            this.ftpServer = false;
            this.sftpServer = false;
            this.taskServerFieldsNameMap.remove(taskName);
            this.taskJsonRecordKeys.remove(taskName);
            this.taskFieldsDateFormat.remove(taskName);
            this.taskCustomerPrismartFieldsMap.remove(taskName);
            this.taskServerStoreCodeMap.remove(taskName);
            this.taskServerUrlMap.remove(taskName);
            this.taskServerTransformStoreCodeMap.remove(taskName);
            this.useCertificateUrlMap.remove(taskName);
            this.taskLocalDirMap.remove(taskName);
            this.taskMap.remove(taskName);
            for (CdiProperties.Task task : this.getTask()) {
                if (IntegrationMode.SERVER_FTP.getName().equals(task.getIntegrationMode())) {
                    this.getTaskFtpServerUserMap().put(task.getTaskName(), AESUtils.decrypt(task.getDatasource().getFtpServerPassword()));
                    this.ftpServer = true;
                    ++this.serverNum;
                }
                if (!IntegrationMode.SERVER_SFTP.getName().equals(task.getIntegrationMode())) continue;
                this.getTaskSftpServerUserMap().put(task.getTaskName(), AESUtils.decrypt(task.getDatasource().getSftpServerPassword()));
                this.sftpServer = true;
                ++this.serverNum;
            }
        }
        if (this.ftpServer) {
            this.getCdiSystem().setFtpServerHost(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getFtpServerHost(), "127.0.0.1"));
            if (cdiProperties.getCdiSystem().getFtpServerPort() != null && !"".equals(cdiProperties.getCdiSystem().getFtpServerHost())) {
                this.getCdiSystem().setFtpServerPort(GenericCdiServerContext.defaultInt(this.getCdiSystem().getFtpServerPort(), 21022));
                this.ftpCustomerServerAddress = new InetSocketAddress(this.getCdiSystem().getFtpServerHost(), (int)this.getCdiSystem().getFtpServerPort());
                log.info("create customerFtpServer, the host is : [{}], the port is : [{}]", (Object)this.getCdiSystem().getFtpServerHost(), (Object)this.getCdiSystem().getFtpServerPort());
            }
        }
        if (this.sftpServer) {
            this.getCdiSystem().setSftpServerHost(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getSftpServerHost(), "127.0.0.1"));
            if (cdiProperties.getCdiSystem().getSftpServerPort() != null && !"".equals(cdiProperties.getCdiSystem().getSftpServerHost())) {
                this.getCdiSystem().setSftpServerPort(GenericCdiServerContext.defaultInt(this.getCdiSystem().getSftpServerPort(), 21023));
                this.sftpCustomerServerAddress = new InetSocketAddress(this.getCdiSystem().getSftpServerHost(), (int)this.getCdiSystem().getSftpServerPort());
                log.info("create customerSftpServer, the host is : [{}], the port is : [{}]", (Object)this.getCdiSystem().getSftpServerHost(), (Object)this.getCdiSystem().getSftpServerPort());
            }
        }
        if (this.ftpCustomerServerAddress != null) {
            this.initializeFtpCustomerUsersPropertiesFile(this.rootDir);
        }
        if (this.sftpCustomerServerAddress != null) {
            this.initializeSftpCustomerUsersPropertiesFile(this.rootDir);
        }
    }

    public void reloadCerClientWrapMap(String customerCode) {
        if (this.getCdiSystem().getCertificateMap() != null && !this.getCdiSystem().getCertificateMap().isEmpty()) {
            for (CdiProperties.Certificate certificate : this.getCdiSystem().getCertificateMap().values()) {
                if (!certificate.getCustomerCode().equals(customerCode)) continue;
                OkHttpsCertClientWrap okHttpsCertClientWrap = new OkHttpsCertClientWrap(this.getCdiSystem().getTimeout(), certificate.getCustomerCode() + "-" + certificate.getCertificateName(), AESUtils.decrypt(certificate.getKeyPass()), AESUtils.decrypt(certificate.getStorePass()));
                this.okHttpsCertClientWrapMap.put(certificate.getCustomerCode(), okHttpsCertClientWrap);
            }
        }
    }

    public GenericCdiServerContext(CdiProperties cdiProperties, CdiService cdiService, StoreService storeService, boolean quickSort) {
        this.cdiProperties = cdiProperties;
        this.cdiService = cdiService;
        this.quickSort = quickSort;
        this.setCdiSystem(new CdiProperties.CdiSystem());
        this.setTask(new ArrayList<CdiProperties.Task>());
        this.taskServerFieldsNameMap = new HashMap<String, Map<String, CdiProperties.Field>>();
        this.taskFieldsDateFormat = new HashMap<String, Map<String, SimpleDateFormat>>();
        this.taskCustomerPrismartFieldsMap = new HashMap<String, Map<String, CdiProperties.Field>>();
        this.taskServerStoreCodeMap = new HashMap<String, Map<String, CdiProperties.Store>>();
        this.taskServerTransformStoreCodeMap = new HashMap<String, Map<String, String>>();
        this.taskServerUrlMap = new HashMap<String, Map<String, String>>();
        this.taskJsonRecordKeys = new HashMap<String, String>();
        this.taskMap = new HashMap<String, CdiProperties.Task>();
        this.taskLocalDirMap = new HashMap<String, File>();
        this.taskSftpServerUserMap = new HashMap<String, String>();
        this.taskFtpServerUserMap = new HashMap<String, String>();
        this.useCertificateUrlMap = new HashMap<String, Map<String, Boolean>>();
        BeanUtils.copyProperties((Object)cdiProperties, (Object)this);
        BeanUtils.copyProperties((Object)cdiProperties.getCdiSystem(), (Object)this.getCdiSystem());
        this.locale = new Locale(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getLocale(), "zh_CN"));
        this.timeZone = TimeZone.getTimeZone(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getTimeZone(), "Asia/Shanghai"));
        cdiProperties.getCdiSystem().setCharset(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getCharset(), "UTF-8"));
        this.integrationHome = System.getProperty("integration.home");
        for (CdiProperties.Task task : this.getTask()) {
            if (task.getServerUrls() == null || task.getServerUrls().size() == 0) {
                log.warn("Cannot find Server integration URL in task : {}, {}", (Object)task.getTaskName(), (Object)task);
            }
            this.taskStoreMap = new HashMap<String, Map<String, CdiProperties.Store>>();
            HashMap<String, CdiProperties.Store> map = new HashMap<String, CdiProperties.Store>();
            for (CdiProperties.Store store2 : task.getStores()) {
                map.put(store2.getHanshowStoreCode(), store2);
            }
            this.taskStoreMap.put(task.getTaskName(), map);
            this.taskServerFieldsNameMap.put(task.getTaskName(), task.getFields().stream().collect(Collectors.toMap(CdiProperties.Field::getHanshow, Function.identity(), (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new)));
            this.taskFieldsDateFormat.put(task.getTaskName(), task.getFields().stream().filter(field -> StringUtils.isNotBlank((String)field.getDateFormat())).collect(Collectors.toMap(CdiProperties.Field::getHanshow, value -> new SimpleDateFormat(value.getDateFormat()))));
            this.taskCustomerPrismartFieldsMap.put(task.getTaskName(), task.getFields().stream().collect(Collectors.toMap(CdiProperties.Field::getCustomer, Function.identity(), (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new)));
            this.taskServerStoreCodeMap.put(task.getTaskName(), task.getStores().stream().collect(Collectors.toMap(store -> StringUtils.isBlank((String)store.getHanshowStoreCode()) ? store.getStoreCode() : store.getHanshowStoreCode(), Function.identity(), (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new)));
            this.taskServerUrlMap.put(task.getTaskName(), task.getServerUrls().stream().collect(Collectors.toMap(CdiProperties.ServerUrl::getIntegrationUrl, CdiProperties.ServerUrl::getCallbackUrl, (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new)));
            this.useCertificateUrlMap.put(task.getTaskName(), task.getServerUrls().stream().collect(Collectors.toMap(CdiProperties.ServerUrl::getIntegrationUrl, CdiProperties.ServerUrl::getUseCertificate, (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new)));
            this.taskServerTransformStoreCodeMap.put(task.getTaskName(), task.getStores().stream().collect(Collectors.toMap(CdiProperties.Store::getStoreCode, CdiProperties.Store::getHanshowStoreCode, (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new)));
            if (this.taskServerFieldsNameMap.get(task.getTaskName()) != null && this.taskServerFieldsNameMap.get(task.getTaskName()).containsKey("sku")) {
                this.taskJsonRecordKeys.put(task.getTaskName(), this.taskServerFieldsNameMap.get(task.getTaskName()).get("sku").getCustomer());
            }
            if (this.taskServerFieldsNameMap != null && !this.taskServerFieldsNameMap.get(task.getTaskName()).containsKey("sku")) {
                throw new IllegalArgumentException("the filed not contains 'sku'");
            }
            if (task.getDatasource().getLocalDir() != null && !"".equals(task.getDatasource().getLocalDir())) {
                this.taskLocalDirMap.put(task.getTaskName(), new File(task.getDatasource().getLocalDir()));
                if (IntegrationMode.CLIENT_LOCAL.getName().equals(task.getIntegrationMode()) && this.taskServerStoreCodeMap != null && task.getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.ByDir.getType()) {
                    this.initFileDir(task.getTaskName());
                } else if (IntegrationMode.CLIENT_FTP.getName().equals(task.getIntegrationMode()) || IntegrationMode.CLIENT_SFTP.getName().equals(task.getIntegrationMode())) {
                    this.taskLocalDirMap.put(task.getTaskName(), this.initializeDirectory(this.taskLocalDirMap.get(task.getTaskName()), GenericCdiServerContext.defaultString(task.getDatasource().getLocalDir(), "local")));
                    this.initFileDir(task.getTaskName());
                }
            }
            if (IntegrationMode.SERVER_FTP.getName().equals(task.getIntegrationMode())) {
                this.getTaskFtpServerUserMap().put(task.getTaskName(), AESUtils.decrypt(task.getDatasource().getFtpServerPassword()));
                this.ftpServer = true;
                ++this.serverNum;
            }
            if (IntegrationMode.SERVER_SFTP.getName().equals(task.getIntegrationMode())) {
                this.getTaskSftpServerUserMap().put(task.getTaskName(), AESUtils.decrypt(task.getDatasource().getSftpServerPassword()));
                this.sftpServer = true;
                ++this.serverNum;
            }
            this.taskMap.put(task.getTaskName(), task);
        }
        this.getCdiSystem().setMaxNumPerPost(GenericCdiServerContext.defaultInt(cdiProperties.getCdiSystem().getMaxNumPerPost(), 1000));
        this.getCdiSystem().setDataFileKeepingDays(GenericCdiServerContext.defaultInt(cdiProperties.getCdiSystem().getDataFileKeepingDays(), 7));
        this.logDir = new File("logs");
        this.rootDir = this.initializeDirectory(this.rootDir, "hanshow_data");
        this.msgDir = new File(this.rootDir, "msg");
        this.msgFileDir = new File(this.rootDir, "msg_file");
        this.temporaryDir = this.initializeDirectory(this.temporaryDir, "tmp");
        this.backupDir = this.initializeDirectory(this.backupDir, "bak");
        this.uploadDir = this.initializeDirectory(this.uploadDir, "upload");
        this.downloadDir = this.initializeDirectory(this.downloadDir, "download");
        this.getCdiSystem().setCdiFtpSwitch(GenericCdiServerContext.defaultBoolean(cdiProperties.getCdiSystem().isCdiFtpSwitch(), false));
        if (this.getCdiSystem().isCdiFtpSwitch()) {
            this.getCdiSystem().setCdiFtpHost(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getCdiFtpHost(), "127.0.0.1"));
            if (cdiProperties.getCdiSystem().getCdiFtpPort() != null && !"".equals(cdiProperties.getCdiSystem().getCdiFtpHost())) {
                this.getCdiSystem().setCdiFtpPort(GenericCdiServerContext.defaultInt(this.getCdiSystem().getCdiFtpPort(), 21021));
                this.cdiFtpAddress = new InetSocketAddress(this.getCdiSystem().getCdiFtpHost(), (int)this.getCdiSystem().getCdiFtpPort());
                log.info("create ftpServer, the host is : [{}], the port is : [{}]", (Object)this.getCdiSystem().getCdiFtpHost(), (Object)this.getCdiSystem().getCdiFtpPort());
            }
        }
        if (this.ftpServer) {
            this.getCdiSystem().setFtpServerHost(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getFtpServerHost(), "127.0.0.1"));
            if (cdiProperties.getCdiSystem().getFtpServerPort() != null && !"".equals(cdiProperties.getCdiSystem().getFtpServerHost())) {
                this.getCdiSystem().setFtpServerPort(GenericCdiServerContext.defaultInt(this.getCdiSystem().getFtpServerPort(), 21022));
                this.ftpCustomerServerAddress = new InetSocketAddress(this.getCdiSystem().getFtpServerHost(), (int)this.getCdiSystem().getFtpServerPort());
                log.info("create customerFtpServer, the host is : [{}], the port is : [{}]", (Object)this.getCdiSystem().getFtpServerHost(), (Object)this.getCdiSystem().getFtpServerPort());
            }
        }
        if (this.sftpServer) {
            this.getCdiSystem().setSftpServerHost(GenericCdiServerContext.defaultString(cdiProperties.getCdiSystem().getSftpServerHost(), "127.0.0.1"));
            if (cdiProperties.getCdiSystem().getSftpServerPort() != null && !"".equals(cdiProperties.getCdiSystem().getSftpServerHost())) {
                this.getCdiSystem().setSftpServerPort(GenericCdiServerContext.defaultInt(this.getCdiSystem().getSftpServerPort(), 21023));
                this.sftpCustomerServerAddress = new InetSocketAddress(this.getCdiSystem().getSftpServerHost(), (int)this.getCdiSystem().getSftpServerPort());
                log.info("create customerSftpServer, the host is : [{}], the port is : [{}]", (Object)this.getCdiSystem().getSftpServerHost(), (Object)this.getCdiSystem().getSftpServerPort());
            }
        }
        this.initFileBakDir();
        if (this.cdiFtpAddress != null) {
            this.initializeFtpUsersPropertiesFile(this.rootDir);
        }
        if (this.ftpCustomerServerAddress != null) {
            this.initializeFtpCustomerUsersPropertiesFile(this.rootDir);
        }
        if (this.sftpCustomerServerAddress != null) {
            this.initializeSftpCustomerUsersPropertiesFile(this.rootDir);
        }
        this.okHttpClientWrap = new OkHttpClientWrap(this.getCdiSystem().getTimeout());
        this.okHttpsClientWrap = new OkHttpsClientWrap(this.getCdiSystem().getTimeout());
        this.okHttpsCertClientWrapMap = new HashMap<String, OkHttpsCertClientWrap>();
        if (this.getCdiSystem().getCertificateMap() != null && this.getCdiSystem().getCertificateMap().size() > 0) {
            for (CdiProperties.Certificate certificate : this.getCdiSystem().getCertificateMap().values()) {
                OkHttpsCertClientWrap okHttpsCertClientWrap = new OkHttpsCertClientWrap(this.getCdiSystem().getTimeout(), certificate.getCustomerCode() + "-" + certificate.getCertificateName(), AESUtils.decrypt(certificate.getKeyPass()), AESUtils.decrypt(certificate.getStorePass()));
                this.okHttpsCertClientWrapMap.put(certificate.getCustomerCode(), okHttpsCertClientWrap);
            }
        }
        this.serverSender = new ServerSender(cdiProperties, cdiService, storeService, this.okHttpClientWrap, this.okHttpsClientWrap, this.okHttpsCertClientWrapMap, this.useCertificateUrlMap);
        this.serverSender.start();
    }

    private static String defaultString(String parameter, String defaultValue) {
        return null == parameter ? defaultValue : parameter;
    }

    private static boolean defaultBoolean(boolean parameter, boolean defaultValue) {
        return parameter || defaultValue;
    }

    private static int defaultInt(int parameter, int defaultValue) {
        return 0 == parameter ? defaultValue : parameter;
    }

    private File initializeDirectory(File file, String directory) {
        file = new File(this.integrationHome, directory);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("Temporary directory specified by system.temporary.dir is not a directory: " + file.getAbsolutePath());
            }
            if (!file.canWrite()) {
                throw new IllegalArgumentException("No permission to write temporary directory specified by system.temporary.dir: " + file.getAbsolutePath());
            }
        } else if (!file.mkdirs()) {
            throw new IllegalArgumentException("No permission to create temporary directory specified by system.temporary.dir: " + file.getAbsolutePath());
        }
        return file;
    }

    private void initializeFtpUsersPropertiesFile(File root) {
        Properties ftpUserProperties = new Properties();
        String ftpUser = "default";
        String ftpPwd = "Hanshow5!";
        ftpUserProperties.put(String.format("ftpserver.user.%s.homedirectory", ftpUser), PathHelper.getUserFtpDir(this.rootDir, ftpUser).getAbsolutePath());
        ftpUserProperties.put(String.format("ftpserver.user.%s.userpassword", ftpUser), ftpPwd);
        ftpUserProperties.put(String.format("ftpserver.user.%s.writepermission", ftpUser), "true");
        this.ftpUsersPropertiesFile = new File(root, "ftpUsers.properties");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.ftpUsersPropertiesFile), StandardCharsets.UTF_8);){
            ftpUserProperties.store(writer, "FTP Users Settings");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Create FTP users settings properties file failed: " + this.ftpUsersPropertiesFile.getAbsolutePath());
        }
    }

    private void initializeFtpCustomerUsersPropertiesFile(File root) {
        Properties ftpCustomerUserProperties = new Properties();
        for (String userName : this.taskFtpServerUserMap.keySet()) {
            ftpCustomerUserProperties.put(String.format("ftpserver.user.%s.homedirectory", userName), PathHelper.getUserFtpDir(this.rootDir, userName).getAbsolutePath());
            ftpCustomerUserProperties.put(String.format("ftpserver.user.%s.userpassword", userName), this.taskFtpServerUserMap.get(userName));
            ftpCustomerUserProperties.put(String.format("ftpserver.user.%s.writepermission", userName), "true");
            ftpCustomerUserProperties.put(String.format("ftpserver.user.%s.maxloginnumber", userName), "99");
            ftpCustomerUserProperties.put(String.format("ftpserver.user.%s.maxloginperip", userName), "10");
        }
        this.ftpCustomerUsersPropertiesFile = new File(root, "ftpCustomerUsers.properties");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.ftpCustomerUsersPropertiesFile), StandardCharsets.UTF_8);){
            ftpCustomerUserProperties.store(writer, "FTP Users Settings");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Create FTP users settings properties file failed: " + this.ftpCustomerUsersPropertiesFile.getAbsolutePath());
        }
    }

    private void initializeSftpCustomerUsersPropertiesFile(File root) {
        Properties sftpCustomerUserProperties = new Properties();
        this.sftpUsers = new HashSet<String>();
        for (String userName : this.taskSftpServerUserMap.keySet()) {
            this.sftpUsers.add(userName);
            sftpCustomerUserProperties.put(String.format("sftpserver.user.%s.homedirectory", userName), PathHelper.getUserSftpDir(this.rootDir, userName).getAbsolutePath());
            sftpCustomerUserProperties.put(String.format("sftpserver.user.%s.userpassword", userName), this.taskSftpServerUserMap.get(userName));
            sftpCustomerUserProperties.put(String.format("sftpserver.user.%s.writepermission", userName), "true");
            sftpCustomerUserProperties.put(String.format("sftpserver.user.%s.maxloginnumber", userName), "99");
            sftpCustomerUserProperties.put(String.format("sftpserver.user.%s.maxloginperip", userName), "10");
        }
        this.sftpCustomerUsersPropertiesFile = new File(root, "sftpCustomerUsers.properties");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.sftpCustomerUsersPropertiesFile), StandardCharsets.UTF_8);){
            sftpCustomerUserProperties.store(writer, "SFTP Users Settings");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Create SFTP users settings properties file failed: " + this.sftpCustomerUsersPropertiesFile.getAbsolutePath());
        }
        this.userManager = new UserManager(this.sftpUsers, sftpCustomerUserProperties);
    }

    private void initFileDir(String taskName) {
        this.taskServerTransformStoreCodeMap.get(taskName).keySet().forEach(storeCode -> {
            File file = new File(this.taskLocalDirMap.get(taskName).getAbsolutePath() + File.separator + storeCode);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("Temporary directory specified by system.dir is not a directory: " + file.getAbsolutePath());
                }
                if (!file.canWrite()) {
                    throw new IllegalArgumentException("No permission to write temporary directory specified by system.dir: " + file.getAbsolutePath());
                }
            } else if (!file.mkdirs()) {
                throw new IllegalArgumentException("No permission to create temporary directory specified by system.dir: " + file.getAbsolutePath());
            }
        });
    }

    private void initFileBakDir() {
        this.taskServerStoreCodeMap.keySet().forEach(taskName -> {
            File file = new File(this.backupDir.getAbsolutePath() + File.separator + taskName);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("Temporary directory specified by system.dir is not a directory: " + file.getAbsolutePath());
                }
                if (!file.canWrite()) {
                    throw new IllegalArgumentException("No permission to write temporary directory specified by system.dir: " + file.getAbsolutePath());
                }
            } else if (!file.mkdirs()) {
                throw new IllegalArgumentException("No permission to create temporary directory specified by system.dir: " + file.getAbsolutePath());
            }
        });
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public File getMsgFileDir() {
        return this.msgFileDir;
    }

    public File getMsgDir() {
        return this.msgDir;
    }

    public File getTemporaryDir() {
        return this.temporaryDir;
    }

    public File getLogDir() {
        return this.logDir;
    }

    public File getBackupDir() {
        return this.backupDir;
    }

    public File getUploadDir() {
        return this.uploadDir;
    }

    public File getDownloadDir() {
        return this.downloadDir;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public InetSocketAddress getCdiFtpAddress() {
        return this.cdiFtpAddress;
    }

    public File getFtpUsersPropertiesFile() {
        return this.ftpUsersPropertiesFile;
    }

    public InetSocketAddress getFtpCustomerServerAddress() {
        return this.ftpCustomerServerAddress;
    }

    public File getFtpCustomerUsersPropertiesFile() {
        return this.ftpCustomerUsersPropertiesFile;
    }

    public InetSocketAddress getSftpCustomerServerAddress() {
        return this.sftpCustomerServerAddress;
    }

    public File getSftpCustomerUsersPropertiesFile() {
        return this.sftpCustomerUsersPropertiesFile;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public String getIntegrationHome() {
        return this.integrationHome;
    }

    public Map<String, String> getTaskJsonRecordKeys() {
        return this.taskJsonRecordKeys;
    }

    public Map<String, Map<String, CdiProperties.Field>> getTaskServerFieldsNameMap() {
        return this.taskServerFieldsNameMap;
    }

    public Map<String, Map<String, CdiProperties.Field>> getTaskCustomerPrismartFieldsMap() {
        return this.taskCustomerPrismartFieldsMap;
    }

    public Map<String, Map<String, CdiProperties.Store>> getTaskServerStoreCodeMap() {
        return this.taskServerStoreCodeMap;
    }

    public Map<String, Map<String, String>> getTaskServerTransformStoreCodeMap() {
        return this.taskServerTransformStoreCodeMap;
    }

    public Map<String, Map<String, String>> getTaskServerUrlMap() {
        return this.taskServerUrlMap;
    }

    public Map<String, Map<String, SimpleDateFormat>> getTaskFieldsDateFormat() {
        return this.taskFieldsDateFormat;
    }

    public Map<String, String> getTaskFtpServerUserMap() {
        return this.taskFtpServerUserMap;
    }

    public Map<String, String> getTaskSftpServerUserMap() {
        return this.taskSftpServerUserMap;
    }

    public Set<String> getSftpUsers() {
        return this.sftpUsers;
    }

    public CdiService getCdiService() {
        return this.cdiService;
    }

    public StoreService getStoreService() {
        return this.storeService;
    }

    public Map<String, Map<String, CdiProperties.Store>> getTaskStoreMap() {
        return this.taskStoreMap;
    }

    public Map<String, CdiProperties.Task> getTaskMap() {
        return this.taskMap;
    }

    public OkHttpClientWrap getOkHttpClientWrap() {
        return this.okHttpClientWrap;
    }

    public OkHttpsClientWrap getOkHttpsClientWrap() {
        return this.okHttpsClientWrap;
    }

    public Map<String, OkHttpsCertClientWrap> getOkHttpsCertClientWrapMap() {
        return this.okHttpsCertClientWrapMap;
    }

    public Map<String, String> getTaskLimit() {
        return this.taskLimit;
    }

    public Map<String, Map<String, Boolean>> getUseCertificateUrlMap() {
        return this.useCertificateUrlMap;
    }

    public ServerSender getServerSender() {
        return this.serverSender;
    }

    public boolean isFtpServer() {
        return this.ftpServer;
    }

    public boolean isSftpServer() {
        return this.sftpServer;
    }

    public boolean isCdiSwitch() {
        return this.cdiSwitch;
    }

    public boolean isQuickSort() {
        return this.quickSort;
    }

    public int getServerNum() {
        return this.serverNum;
    }

    public Map<String, File> getTaskLocalDirMap() {
        return this.taskLocalDirMap;
    }

    public CdiProperties getCdiProperties() {
        return this.cdiProperties;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public void setMsgFileDir(File msgFileDir) {
        this.msgFileDir = msgFileDir;
    }

    public void setMsgDir(File msgDir) {
        this.msgDir = msgDir;
    }

    public void setTemporaryDir(File temporaryDir) {
        this.temporaryDir = temporaryDir;
    }

    public void setLogDir(File logDir) {
        this.logDir = logDir;
    }

    public void setBackupDir(File backupDir) {
        this.backupDir = backupDir;
    }

    public void setUploadDir(File uploadDir) {
        this.uploadDir = uploadDir;
    }

    public void setDownloadDir(File downloadDir) {
        this.downloadDir = downloadDir;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setCdiFtpAddress(InetSocketAddress cdiFtpAddress) {
        this.cdiFtpAddress = cdiFtpAddress;
    }

    public void setFtpUsersPropertiesFile(File ftpUsersPropertiesFile) {
        this.ftpUsersPropertiesFile = ftpUsersPropertiesFile;
    }

    public void setFtpCustomerServerAddress(InetSocketAddress ftpCustomerServerAddress) {
        this.ftpCustomerServerAddress = ftpCustomerServerAddress;
    }

    public void setFtpCustomerUsersPropertiesFile(File ftpCustomerUsersPropertiesFile) {
        this.ftpCustomerUsersPropertiesFile = ftpCustomerUsersPropertiesFile;
    }

    public void setSftpCustomerServerAddress(InetSocketAddress sftpCustomerServerAddress) {
        this.sftpCustomerServerAddress = sftpCustomerServerAddress;
    }

    public void setSftpCustomerUsersPropertiesFile(File sftpCustomerUsersPropertiesFile) {
        this.sftpCustomerUsersPropertiesFile = sftpCustomerUsersPropertiesFile;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setIntegrationHome(String integrationHome) {
        this.integrationHome = integrationHome;
    }

    public void setTaskJsonRecordKeys(Map<String, String> taskJsonRecordKeys) {
        this.taskJsonRecordKeys = taskJsonRecordKeys;
    }

    public void setTaskServerFieldsNameMap(Map<String, Map<String, CdiProperties.Field>> taskServerFieldsNameMap) {
        this.taskServerFieldsNameMap = taskServerFieldsNameMap;
    }

    public void setTaskCustomerPrismartFieldsMap(Map<String, Map<String, CdiProperties.Field>> taskCustomerPrismartFieldsMap) {
        this.taskCustomerPrismartFieldsMap = taskCustomerPrismartFieldsMap;
    }

    public void setTaskServerStoreCodeMap(Map<String, Map<String, CdiProperties.Store>> taskServerStoreCodeMap) {
        this.taskServerStoreCodeMap = taskServerStoreCodeMap;
    }

    public void setTaskServerTransformStoreCodeMap(Map<String, Map<String, String>> taskServerTransformStoreCodeMap) {
        this.taskServerTransformStoreCodeMap = taskServerTransformStoreCodeMap;
    }

    public void setTaskServerUrlMap(Map<String, Map<String, String>> taskServerUrlMap) {
        this.taskServerUrlMap = taskServerUrlMap;
    }

    public void setTaskFieldsDateFormat(Map<String, Map<String, SimpleDateFormat>> taskFieldsDateFormat) {
        this.taskFieldsDateFormat = taskFieldsDateFormat;
    }

    public void setTaskFtpServerUserMap(Map<String, String> taskFtpServerUserMap) {
        this.taskFtpServerUserMap = taskFtpServerUserMap;
    }

    public void setTaskSftpServerUserMap(Map<String, String> taskSftpServerUserMap) {
        this.taskSftpServerUserMap = taskSftpServerUserMap;
    }

    public void setSftpUsers(Set<String> sftpUsers) {
        this.sftpUsers = sftpUsers;
    }

    public void setCdiService(CdiService cdiService) {
        this.cdiService = cdiService;
    }

    public void setStoreService(StoreService storeService) {
        this.storeService = storeService;
    }

    public void setTaskStoreMap(Map<String, Map<String, CdiProperties.Store>> taskStoreMap) {
        this.taskStoreMap = taskStoreMap;
    }

    public void setTaskMap(Map<String, CdiProperties.Task> taskMap) {
        this.taskMap = taskMap;
    }

    public void setOkHttpClientWrap(OkHttpClientWrap okHttpClientWrap) {
        this.okHttpClientWrap = okHttpClientWrap;
    }

    public void setOkHttpsClientWrap(OkHttpsClientWrap okHttpsClientWrap) {
        this.okHttpsClientWrap = okHttpsClientWrap;
    }

    public void setOkHttpsCertClientWrapMap(Map<String, OkHttpsCertClientWrap> okHttpsCertClientWrapMap) {
        this.okHttpsCertClientWrapMap = okHttpsCertClientWrapMap;
    }

    public void setTaskLimit(Map<String, String> taskLimit) {
        this.taskLimit = taskLimit;
    }

    public void setUseCertificateUrlMap(Map<String, Map<String, Boolean>> useCertificateUrlMap) {
        this.useCertificateUrlMap = useCertificateUrlMap;
    }

    public void setServerSender(ServerSender serverSender) {
        this.serverSender = serverSender;
    }

    public void setFtpServer(boolean ftpServer) {
        this.ftpServer = ftpServer;
    }

    public void setSftpServer(boolean sftpServer) {
        this.sftpServer = sftpServer;
    }

    public void setCdiSwitch(boolean cdiSwitch) {
        this.cdiSwitch = cdiSwitch;
    }

    public void setQuickSort(boolean quickSort) {
        this.quickSort = quickSort;
    }

    public void setServerNum(int serverNum) {
        this.serverNum = serverNum;
    }

    public void setTaskLocalDirMap(Map<String, File> taskLocalDirMap) {
        this.taskLocalDirMap = taskLocalDirMap;
    }

    public void setCdiProperties(CdiProperties cdiProperties) {
        this.cdiProperties = cdiProperties;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericCdiServerContext)) {
            return false;
        }
        GenericCdiServerContext other = (GenericCdiServerContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFtpServer() != other.isFtpServer()) {
            return false;
        }
        if (this.isSftpServer() != other.isSftpServer()) {
            return false;
        }
        if (this.isCdiSwitch() != other.isCdiSwitch()) {
            return false;
        }
        if (this.isQuickSort() != other.isQuickSort()) {
            return false;
        }
        if (this.getServerNum() != other.getServerNum()) {
            return false;
        }
        File this$rootDir = this.getRootDir();
        File other$rootDir = other.getRootDir();
        if (this$rootDir == null ? other$rootDir != null : !((Object)this$rootDir).equals(other$rootDir)) {
            return false;
        }
        File this$msgFileDir = this.getMsgFileDir();
        File other$msgFileDir = other.getMsgFileDir();
        if (this$msgFileDir == null ? other$msgFileDir != null : !((Object)this$msgFileDir).equals(other$msgFileDir)) {
            return false;
        }
        File this$msgDir = this.getMsgDir();
        File other$msgDir = other.getMsgDir();
        if (this$msgDir == null ? other$msgDir != null : !((Object)this$msgDir).equals(other$msgDir)) {
            return false;
        }
        File this$temporaryDir = this.getTemporaryDir();
        File other$temporaryDir = other.getTemporaryDir();
        if (this$temporaryDir == null ? other$temporaryDir != null : !((Object)this$temporaryDir).equals(other$temporaryDir)) {
            return false;
        }
        File this$logDir = this.getLogDir();
        File other$logDir = other.getLogDir();
        if (this$logDir == null ? other$logDir != null : !((Object)this$logDir).equals(other$logDir)) {
            return false;
        }
        File this$backupDir = this.getBackupDir();
        File other$backupDir = other.getBackupDir();
        if (this$backupDir == null ? other$backupDir != null : !((Object)this$backupDir).equals(other$backupDir)) {
            return false;
        }
        File this$uploadDir = this.getUploadDir();
        File other$uploadDir = other.getUploadDir();
        if (this$uploadDir == null ? other$uploadDir != null : !((Object)this$uploadDir).equals(other$uploadDir)) {
            return false;
        }
        File this$downloadDir = this.getDownloadDir();
        File other$downloadDir = other.getDownloadDir();
        if (this$downloadDir == null ? other$downloadDir != null : !((Object)this$downloadDir).equals(other$downloadDir)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        TimeZone this$timeZone = this.getTimeZone();
        TimeZone other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        InetSocketAddress this$cdiFtpAddress = this.getCdiFtpAddress();
        InetSocketAddress other$cdiFtpAddress = other.getCdiFtpAddress();
        if (this$cdiFtpAddress == null ? other$cdiFtpAddress != null : !((Object)this$cdiFtpAddress).equals(other$cdiFtpAddress)) {
            return false;
        }
        File this$ftpUsersPropertiesFile = this.getFtpUsersPropertiesFile();
        File other$ftpUsersPropertiesFile = other.getFtpUsersPropertiesFile();
        if (this$ftpUsersPropertiesFile == null ? other$ftpUsersPropertiesFile != null : !((Object)this$ftpUsersPropertiesFile).equals(other$ftpUsersPropertiesFile)) {
            return false;
        }
        InetSocketAddress this$ftpCustomerServerAddress = this.getFtpCustomerServerAddress();
        InetSocketAddress other$ftpCustomerServerAddress = other.getFtpCustomerServerAddress();
        if (this$ftpCustomerServerAddress == null ? other$ftpCustomerServerAddress != null : !((Object)this$ftpCustomerServerAddress).equals(other$ftpCustomerServerAddress)) {
            return false;
        }
        File this$ftpCustomerUsersPropertiesFile = this.getFtpCustomerUsersPropertiesFile();
        File other$ftpCustomerUsersPropertiesFile = other.getFtpCustomerUsersPropertiesFile();
        if (this$ftpCustomerUsersPropertiesFile == null ? other$ftpCustomerUsersPropertiesFile != null : !((Object)this$ftpCustomerUsersPropertiesFile).equals(other$ftpCustomerUsersPropertiesFile)) {
            return false;
        }
        InetSocketAddress this$sftpCustomerServerAddress = this.getSftpCustomerServerAddress();
        InetSocketAddress other$sftpCustomerServerAddress = other.getSftpCustomerServerAddress();
        if (this$sftpCustomerServerAddress == null ? other$sftpCustomerServerAddress != null : !((Object)this$sftpCustomerServerAddress).equals(other$sftpCustomerServerAddress)) {
            return false;
        }
        File this$sftpCustomerUsersPropertiesFile = this.getSftpCustomerUsersPropertiesFile();
        File other$sftpCustomerUsersPropertiesFile = other.getSftpCustomerUsersPropertiesFile();
        if (this$sftpCustomerUsersPropertiesFile == null ? other$sftpCustomerUsersPropertiesFile != null : !((Object)this$sftpCustomerUsersPropertiesFile).equals(other$sftpCustomerUsersPropertiesFile)) {
            return false;
        }
        UserManager this$userManager = this.getUserManager();
        UserManager other$userManager = other.getUserManager();
        if (this$userManager == null ? other$userManager != null : !this$userManager.equals(other$userManager)) {
            return false;
        }
        String this$integrationHome = this.getIntegrationHome();
        String other$integrationHome = other.getIntegrationHome();
        if (this$integrationHome == null ? other$integrationHome != null : !this$integrationHome.equals(other$integrationHome)) {
            return false;
        }
        Map<String, String> this$taskJsonRecordKeys = this.getTaskJsonRecordKeys();
        Map<String, String> other$taskJsonRecordKeys = other.getTaskJsonRecordKeys();
        if (this$taskJsonRecordKeys == null ? other$taskJsonRecordKeys != null : !((Object)this$taskJsonRecordKeys).equals(other$taskJsonRecordKeys)) {
            return false;
        }
        Map<String, Map<String, CdiProperties.Field>> this$taskServerFieldsNameMap = this.getTaskServerFieldsNameMap();
        Map<String, Map<String, CdiProperties.Field>> other$taskServerFieldsNameMap = other.getTaskServerFieldsNameMap();
        if (this$taskServerFieldsNameMap == null ? other$taskServerFieldsNameMap != null : !((Object)this$taskServerFieldsNameMap).equals(other$taskServerFieldsNameMap)) {
            return false;
        }
        Map<String, Map<String, CdiProperties.Field>> this$taskCustomerPrismartFieldsMap = this.getTaskCustomerPrismartFieldsMap();
        Map<String, Map<String, CdiProperties.Field>> other$taskCustomerPrismartFieldsMap = other.getTaskCustomerPrismartFieldsMap();
        if (this$taskCustomerPrismartFieldsMap == null ? other$taskCustomerPrismartFieldsMap != null : !((Object)this$taskCustomerPrismartFieldsMap).equals(other$taskCustomerPrismartFieldsMap)) {
            return false;
        }
        Map<String, Map<String, CdiProperties.Store>> this$taskServerStoreCodeMap = this.getTaskServerStoreCodeMap();
        Map<String, Map<String, CdiProperties.Store>> other$taskServerStoreCodeMap = other.getTaskServerStoreCodeMap();
        if (this$taskServerStoreCodeMap == null ? other$taskServerStoreCodeMap != null : !((Object)this$taskServerStoreCodeMap).equals(other$taskServerStoreCodeMap)) {
            return false;
        }
        Map<String, Map<String, String>> this$taskServerTransformStoreCodeMap = this.getTaskServerTransformStoreCodeMap();
        Map<String, Map<String, String>> other$taskServerTransformStoreCodeMap = other.getTaskServerTransformStoreCodeMap();
        if (this$taskServerTransformStoreCodeMap == null ? other$taskServerTransformStoreCodeMap != null : !((Object)this$taskServerTransformStoreCodeMap).equals(other$taskServerTransformStoreCodeMap)) {
            return false;
        }
        Map<String, Map<String, String>> this$taskServerUrlMap = this.getTaskServerUrlMap();
        Map<String, Map<String, String>> other$taskServerUrlMap = other.getTaskServerUrlMap();
        if (this$taskServerUrlMap == null ? other$taskServerUrlMap != null : !((Object)this$taskServerUrlMap).equals(other$taskServerUrlMap)) {
            return false;
        }
        Map<String, Map<String, SimpleDateFormat>> this$taskFieldsDateFormat = this.getTaskFieldsDateFormat();
        Map<String, Map<String, SimpleDateFormat>> other$taskFieldsDateFormat = other.getTaskFieldsDateFormat();
        if (this$taskFieldsDateFormat == null ? other$taskFieldsDateFormat != null : !((Object)this$taskFieldsDateFormat).equals(other$taskFieldsDateFormat)) {
            return false;
        }
        Map<String, String> this$taskFtpServerUserMap = this.getTaskFtpServerUserMap();
        Map<String, String> other$taskFtpServerUserMap = other.getTaskFtpServerUserMap();
        if (this$taskFtpServerUserMap == null ? other$taskFtpServerUserMap != null : !((Object)this$taskFtpServerUserMap).equals(other$taskFtpServerUserMap)) {
            return false;
        }
        Map<String, String> this$taskSftpServerUserMap = this.getTaskSftpServerUserMap();
        Map<String, String> other$taskSftpServerUserMap = other.getTaskSftpServerUserMap();
        if (this$taskSftpServerUserMap == null ? other$taskSftpServerUserMap != null : !((Object)this$taskSftpServerUserMap).equals(other$taskSftpServerUserMap)) {
            return false;
        }
        Set<String> this$sftpUsers = this.getSftpUsers();
        Set<String> other$sftpUsers = other.getSftpUsers();
        if (this$sftpUsers == null ? other$sftpUsers != null : !((Object)this$sftpUsers).equals(other$sftpUsers)) {
            return false;
        }
        CdiService this$cdiService = this.getCdiService();
        CdiService other$cdiService = other.getCdiService();
        if (this$cdiService == null ? other$cdiService != null : !this$cdiService.equals(other$cdiService)) {
            return false;
        }
        StoreService this$storeService = this.getStoreService();
        StoreService other$storeService = other.getStoreService();
        if (this$storeService == null ? other$storeService != null : !this$storeService.equals(other$storeService)) {
            return false;
        }
        Map<String, Map<String, CdiProperties.Store>> this$taskStoreMap = this.getTaskStoreMap();
        Map<String, Map<String, CdiProperties.Store>> other$taskStoreMap = other.getTaskStoreMap();
        if (this$taskStoreMap == null ? other$taskStoreMap != null : !((Object)this$taskStoreMap).equals(other$taskStoreMap)) {
            return false;
        }
        Map<String, CdiProperties.Task> this$taskMap = this.getTaskMap();
        Map<String, CdiProperties.Task> other$taskMap = other.getTaskMap();
        if (this$taskMap == null ? other$taskMap != null : !((Object)this$taskMap).equals(other$taskMap)) {
            return false;
        }
        OkHttpClientWrap this$okHttpClientWrap = this.getOkHttpClientWrap();
        OkHttpClientWrap other$okHttpClientWrap = other.getOkHttpClientWrap();
        if (this$okHttpClientWrap == null ? other$okHttpClientWrap != null : !this$okHttpClientWrap.equals(other$okHttpClientWrap)) {
            return false;
        }
        OkHttpsClientWrap this$okHttpsClientWrap = this.getOkHttpsClientWrap();
        OkHttpsClientWrap other$okHttpsClientWrap = other.getOkHttpsClientWrap();
        if (this$okHttpsClientWrap == null ? other$okHttpsClientWrap != null : !this$okHttpsClientWrap.equals(other$okHttpsClientWrap)) {
            return false;
        }
        Map<String, OkHttpsCertClientWrap> this$okHttpsCertClientWrapMap = this.getOkHttpsCertClientWrapMap();
        Map<String, OkHttpsCertClientWrap> other$okHttpsCertClientWrapMap = other.getOkHttpsCertClientWrapMap();
        if (this$okHttpsCertClientWrapMap == null ? other$okHttpsCertClientWrapMap != null : !((Object)this$okHttpsCertClientWrapMap).equals(other$okHttpsCertClientWrapMap)) {
            return false;
        }
        Map<String, String> this$taskLimit = this.getTaskLimit();
        Map<String, String> other$taskLimit = other.getTaskLimit();
        if (this$taskLimit == null ? other$taskLimit != null : !((Object)this$taskLimit).equals(other$taskLimit)) {
            return false;
        }
        Map<String, Map<String, Boolean>> this$useCertificateUrlMap = this.getUseCertificateUrlMap();
        Map<String, Map<String, Boolean>> other$useCertificateUrlMap = other.getUseCertificateUrlMap();
        if (this$useCertificateUrlMap == null ? other$useCertificateUrlMap != null : !((Object)this$useCertificateUrlMap).equals(other$useCertificateUrlMap)) {
            return false;
        }
        ServerSender this$serverSender = this.getServerSender();
        ServerSender other$serverSender = other.getServerSender();
        if (this$serverSender == null ? other$serverSender != null : !((Object)this$serverSender).equals(other$serverSender)) {
            return false;
        }
        Map<String, File> this$taskLocalDirMap = this.getTaskLocalDirMap();
        Map<String, File> other$taskLocalDirMap = other.getTaskLocalDirMap();
        if (this$taskLocalDirMap == null ? other$taskLocalDirMap != null : !((Object)this$taskLocalDirMap).equals(other$taskLocalDirMap)) {
            return false;
        }
        CdiProperties this$cdiProperties = this.getCdiProperties();
        CdiProperties other$cdiProperties = other.getCdiProperties();
        return !(this$cdiProperties == null ? other$cdiProperties != null : !((Object)this$cdiProperties).equals(other$cdiProperties));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GenericCdiServerContext;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFtpServer() ? 79 : 97);
        result = result * 59 + (this.isSftpServer() ? 79 : 97);
        result = result * 59 + (this.isCdiSwitch() ? 79 : 97);
        result = result * 59 + (this.isQuickSort() ? 79 : 97);
        result = result * 59 + this.getServerNum();
        File $rootDir = this.getRootDir();
        result = result * 59 + ($rootDir == null ? 43 : ((Object)$rootDir).hashCode());
        File $msgFileDir = this.getMsgFileDir();
        result = result * 59 + ($msgFileDir == null ? 43 : ((Object)$msgFileDir).hashCode());
        File $msgDir = this.getMsgDir();
        result = result * 59 + ($msgDir == null ? 43 : ((Object)$msgDir).hashCode());
        File $temporaryDir = this.getTemporaryDir();
        result = result * 59 + ($temporaryDir == null ? 43 : ((Object)$temporaryDir).hashCode());
        File $logDir = this.getLogDir();
        result = result * 59 + ($logDir == null ? 43 : ((Object)$logDir).hashCode());
        File $backupDir = this.getBackupDir();
        result = result * 59 + ($backupDir == null ? 43 : ((Object)$backupDir).hashCode());
        File $uploadDir = this.getUploadDir();
        result = result * 59 + ($uploadDir == null ? 43 : ((Object)$uploadDir).hashCode());
        File $downloadDir = this.getDownloadDir();
        result = result * 59 + ($downloadDir == null ? 43 : ((Object)$downloadDir).hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        TimeZone $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        InetSocketAddress $cdiFtpAddress = this.getCdiFtpAddress();
        result = result * 59 + ($cdiFtpAddress == null ? 43 : ((Object)$cdiFtpAddress).hashCode());
        File $ftpUsersPropertiesFile = this.getFtpUsersPropertiesFile();
        result = result * 59 + ($ftpUsersPropertiesFile == null ? 43 : ((Object)$ftpUsersPropertiesFile).hashCode());
        InetSocketAddress $ftpCustomerServerAddress = this.getFtpCustomerServerAddress();
        result = result * 59 + ($ftpCustomerServerAddress == null ? 43 : ((Object)$ftpCustomerServerAddress).hashCode());
        File $ftpCustomerUsersPropertiesFile = this.getFtpCustomerUsersPropertiesFile();
        result = result * 59 + ($ftpCustomerUsersPropertiesFile == null ? 43 : ((Object)$ftpCustomerUsersPropertiesFile).hashCode());
        InetSocketAddress $sftpCustomerServerAddress = this.getSftpCustomerServerAddress();
        result = result * 59 + ($sftpCustomerServerAddress == null ? 43 : ((Object)$sftpCustomerServerAddress).hashCode());
        File $sftpCustomerUsersPropertiesFile = this.getSftpCustomerUsersPropertiesFile();
        result = result * 59 + ($sftpCustomerUsersPropertiesFile == null ? 43 : ((Object)$sftpCustomerUsersPropertiesFile).hashCode());
        UserManager $userManager = this.getUserManager();
        result = result * 59 + ($userManager == null ? 43 : $userManager.hashCode());
        String $integrationHome = this.getIntegrationHome();
        result = result * 59 + ($integrationHome == null ? 43 : $integrationHome.hashCode());
        Map<String, String> $taskJsonRecordKeys = this.getTaskJsonRecordKeys();
        result = result * 59 + ($taskJsonRecordKeys == null ? 43 : ((Object)$taskJsonRecordKeys).hashCode());
        Map<String, Map<String, CdiProperties.Field>> $taskServerFieldsNameMap = this.getTaskServerFieldsNameMap();
        result = result * 59 + ($taskServerFieldsNameMap == null ? 43 : ((Object)$taskServerFieldsNameMap).hashCode());
        Map<String, Map<String, CdiProperties.Field>> $taskCustomerPrismartFieldsMap = this.getTaskCustomerPrismartFieldsMap();
        result = result * 59 + ($taskCustomerPrismartFieldsMap == null ? 43 : ((Object)$taskCustomerPrismartFieldsMap).hashCode());
        Map<String, Map<String, CdiProperties.Store>> $taskServerStoreCodeMap = this.getTaskServerStoreCodeMap();
        result = result * 59 + ($taskServerStoreCodeMap == null ? 43 : ((Object)$taskServerStoreCodeMap).hashCode());
        Map<String, Map<String, String>> $taskServerTransformStoreCodeMap = this.getTaskServerTransformStoreCodeMap();
        result = result * 59 + ($taskServerTransformStoreCodeMap == null ? 43 : ((Object)$taskServerTransformStoreCodeMap).hashCode());
        Map<String, Map<String, String>> $taskServerUrlMap = this.getTaskServerUrlMap();
        result = result * 59 + ($taskServerUrlMap == null ? 43 : ((Object)$taskServerUrlMap).hashCode());
        Map<String, Map<String, SimpleDateFormat>> $taskFieldsDateFormat = this.getTaskFieldsDateFormat();
        result = result * 59 + ($taskFieldsDateFormat == null ? 43 : ((Object)$taskFieldsDateFormat).hashCode());
        Map<String, String> $taskFtpServerUserMap = this.getTaskFtpServerUserMap();
        result = result * 59 + ($taskFtpServerUserMap == null ? 43 : ((Object)$taskFtpServerUserMap).hashCode());
        Map<String, String> $taskSftpServerUserMap = this.getTaskSftpServerUserMap();
        result = result * 59 + ($taskSftpServerUserMap == null ? 43 : ((Object)$taskSftpServerUserMap).hashCode());
        Set<String> $sftpUsers = this.getSftpUsers();
        result = result * 59 + ($sftpUsers == null ? 43 : ((Object)$sftpUsers).hashCode());
        CdiService $cdiService = this.getCdiService();
        result = result * 59 + ($cdiService == null ? 43 : $cdiService.hashCode());
        StoreService $storeService = this.getStoreService();
        result = result * 59 + ($storeService == null ? 43 : $storeService.hashCode());
        Map<String, Map<String, CdiProperties.Store>> $taskStoreMap = this.getTaskStoreMap();
        result = result * 59 + ($taskStoreMap == null ? 43 : ((Object)$taskStoreMap).hashCode());
        Map<String, CdiProperties.Task> $taskMap = this.getTaskMap();
        result = result * 59 + ($taskMap == null ? 43 : ((Object)$taskMap).hashCode());
        OkHttpClientWrap $okHttpClientWrap = this.getOkHttpClientWrap();
        result = result * 59 + ($okHttpClientWrap == null ? 43 : $okHttpClientWrap.hashCode());
        OkHttpsClientWrap $okHttpsClientWrap = this.getOkHttpsClientWrap();
        result = result * 59 + ($okHttpsClientWrap == null ? 43 : $okHttpsClientWrap.hashCode());
        Map<String, OkHttpsCertClientWrap> $okHttpsCertClientWrapMap = this.getOkHttpsCertClientWrapMap();
        result = result * 59 + ($okHttpsCertClientWrapMap == null ? 43 : ((Object)$okHttpsCertClientWrapMap).hashCode());
        Map<String, String> $taskLimit = this.getTaskLimit();
        result = result * 59 + ($taskLimit == null ? 43 : ((Object)$taskLimit).hashCode());
        Map<String, Map<String, Boolean>> $useCertificateUrlMap = this.getUseCertificateUrlMap();
        result = result * 59 + ($useCertificateUrlMap == null ? 43 : ((Object)$useCertificateUrlMap).hashCode());
        ServerSender $serverSender = this.getServerSender();
        result = result * 59 + ($serverSender == null ? 43 : ((Object)$serverSender).hashCode());
        Map<String, File> $taskLocalDirMap = this.getTaskLocalDirMap();
        result = result * 59 + ($taskLocalDirMap == null ? 43 : ((Object)$taskLocalDirMap).hashCode());
        CdiProperties $cdiProperties = this.getCdiProperties();
        result = result * 59 + ($cdiProperties == null ? 43 : ((Object)$cdiProperties).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GenericCdiServerContext(rootDir=" + this.getRootDir() + ", msgFileDir=" + this.getMsgFileDir() + ", msgDir=" + this.getMsgDir() + ", temporaryDir=" + this.getTemporaryDir() + ", logDir=" + this.getLogDir() + ", backupDir=" + this.getBackupDir() + ", uploadDir=" + this.getUploadDir() + ", downloadDir=" + this.getDownloadDir() + ", locale=" + this.getLocale() + ", timeZone=" + this.getTimeZone() + ", cdiFtpAddress=" + this.getCdiFtpAddress() + ", ftpUsersPropertiesFile=" + this.getFtpUsersPropertiesFile() + ", ftpCustomerServerAddress=" + this.getFtpCustomerServerAddress() + ", ftpCustomerUsersPropertiesFile=" + this.getFtpCustomerUsersPropertiesFile() + ", sftpCustomerServerAddress=" + this.getSftpCustomerServerAddress() + ", sftpCustomerUsersPropertiesFile=" + this.getSftpCustomerUsersPropertiesFile() + ", userManager=" + this.getUserManager() + ", integrationHome=" + this.getIntegrationHome() + ", taskJsonRecordKeys=" + this.getTaskJsonRecordKeys() + ", taskServerFieldsNameMap=" + this.getTaskServerFieldsNameMap() + ", taskCustomerPrismartFieldsMap=" + this.getTaskCustomerPrismartFieldsMap() + ", taskServerStoreCodeMap=" + this.getTaskServerStoreCodeMap() + ", taskServerTransformStoreCodeMap=" + this.getTaskServerTransformStoreCodeMap() + ", taskServerUrlMap=" + this.getTaskServerUrlMap() + ", taskFieldsDateFormat=" + this.getTaskFieldsDateFormat() + ", taskFtpServerUserMap=" + this.getTaskFtpServerUserMap() + ", taskSftpServerUserMap=" + this.getTaskSftpServerUserMap() + ", sftpUsers=" + this.getSftpUsers() + ", cdiService=" + this.getCdiService() + ", storeService=" + this.getStoreService() + ", taskStoreMap=" + this.getTaskStoreMap() + ", taskMap=" + this.getTaskMap() + ", okHttpClientWrap=" + this.getOkHttpClientWrap() + ", okHttpsClientWrap=" + this.getOkHttpsClientWrap() + ", okHttpsCertClientWrapMap=" + this.getOkHttpsCertClientWrapMap() + ", taskLimit=" + this.getTaskLimit() + ", useCertificateUrlMap=" + this.getUseCertificateUrlMap() + ", serverSender=" + this.getServerSender() + ", ftpServer=" + this.isFtpServer() + ", sftpServer=" + this.isSftpServer() + ", cdiSwitch=" + this.isCdiSwitch() + ", quickSort=" + this.isQuickSort() + ", serverNum=" + this.getServerNum() + ", taskLocalDirMap=" + this.getTaskLocalDirMap() + ", cdiProperties=" + this.getCdiProperties() + ")";
    }
}

