/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.core;

import com.hanshow.cdi.GenericCdiServer;
import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.cdi.core.IntegrateTask;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.cdi.service.CdiService;
import com.hanshow.cdi.service.StoreService;
import com.hanshow.cdi.util.ReadConfig;
import com.hanshow.cdi.util.Utils;
import java.io.File;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class InitializeCdiServer {
    private static final Logger log = LogManager.getLogger(InitializeCdiServer.class);
    private GenericCdiServer cdiServer;
    private GenericCdiServerContext serverContext;
    private CdiService cdiService;
    private StoreService storeService;
    private CdiProperties cdiProperties;
    private int ftpMaxLogin;
    ApplicationContext applicationContext;

    @Autowired
    public InitializeCdiServer(Environment environment, CdiService cdiService, ApplicationContext applicationContext, StoreService storeService) throws Exception {
        this.cdiService = cdiService;
        this.storeService = storeService;
        if (((Boolean)environment.getProperty("cdi.switch", Boolean.class, (Object)false)).booleanValue()) {
            storeService.createHistory();
            cdiService.createTable();
        }
        PropertiesConfiguration p = new PropertiesConfiguration("length.properties");
        this.cdiProperties = Utils.stringToItem(ReadConfig.read(new File(p.getFile().getParent(), "cdi")), CdiProperties.class);
        IntegrateTask.genericCdiServerContext = this.serverContext = new GenericCdiServerContext(this.cdiProperties, cdiService, storeService, (Boolean)environment.getProperty("cdi.quickSort", Boolean.class, (Object)false));
        applicationContext.getBeanDefinitionNames();
        this.applicationContext = applicationContext;
    }

    public void start() throws Exception {
        this.cdiServer = new GenericCdiServer();
        this.cdiServer.start(this.cdiService, this.serverContext, this.storeService, this.ftpMaxLogin);
    }

    public GenericCdiServer getCdiServer() {
        return this.cdiServer;
    }

    public GenericCdiServerContext getServerContext() {
        return this.serverContext;
    }

    public CdiService getCdiService() {
        return this.cdiService;
    }

    public StoreService getStoreService() {
        return this.storeService;
    }

    public CdiProperties getCdiProperties() {
        return this.cdiProperties;
    }

    public int getFtpMaxLogin() {
        return this.ftpMaxLogin;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setCdiServer(GenericCdiServer cdiServer) {
        this.cdiServer = cdiServer;
    }

    public void setServerContext(GenericCdiServerContext serverContext) {
        this.serverContext = serverContext;
    }

    public void setCdiService(CdiService cdiService) {
        this.cdiService = cdiService;
    }

    public void setStoreService(StoreService storeService) {
        this.storeService = storeService;
    }

    public void setCdiProperties(CdiProperties cdiProperties) {
        this.cdiProperties = cdiProperties;
    }

    public void setFtpMaxLogin(int ftpMaxLogin) {
        this.ftpMaxLogin = ftpMaxLogin;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InitializeCdiServer)) {
            return false;
        }
        InitializeCdiServer other = (InitializeCdiServer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFtpMaxLogin() != other.getFtpMaxLogin()) {
            return false;
        }
        GenericCdiServer this$cdiServer = this.getCdiServer();
        GenericCdiServer other$cdiServer = other.getCdiServer();
        if (this$cdiServer == null ? other$cdiServer != null : !this$cdiServer.equals(other$cdiServer)) {
            return false;
        }
        GenericCdiServerContext this$serverContext = this.getServerContext();
        GenericCdiServerContext other$serverContext = other.getServerContext();
        if (this$serverContext == null ? other$serverContext != null : !((Object)this$serverContext).equals(other$serverContext)) {
            return false;
        }
        CdiService this$cdiService = this.getCdiService();
        CdiService other$cdiService = other.getCdiService();
        if (this$cdiService == null ? other$cdiService != null : !this$cdiService.equals(other$cdiService)) {
            return false;
        }
        StoreService this$storeService = this.getStoreService();
        StoreService other$storeService = other.getStoreService();
        if (this$storeService == null ? other$storeService != null : !this$storeService.equals(other$storeService)) {
            return false;
        }
        CdiProperties this$cdiProperties = this.getCdiProperties();
        CdiProperties other$cdiProperties = other.getCdiProperties();
        if (this$cdiProperties == null ? other$cdiProperties != null : !((Object)this$cdiProperties).equals(other$cdiProperties)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        return !(this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InitializeCdiServer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFtpMaxLogin();
        GenericCdiServer $cdiServer = this.getCdiServer();
        result = result * 59 + ($cdiServer == null ? 43 : $cdiServer.hashCode());
        GenericCdiServerContext $serverContext = this.getServerContext();
        result = result * 59 + ($serverContext == null ? 43 : ((Object)$serverContext).hashCode());
        CdiService $cdiService = this.getCdiService();
        result = result * 59 + ($cdiService == null ? 43 : $cdiService.hashCode());
        StoreService $storeService = this.getStoreService();
        result = result * 59 + ($storeService == null ? 43 : $storeService.hashCode());
        CdiProperties $cdiProperties = this.getCdiProperties();
        result = result * 59 + ($cdiProperties == null ? 43 : ((Object)$cdiProperties).hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        return result;
    }

    public String toString() {
        return "InitializeCdiServer(cdiServer=" + this.getCdiServer() + ", serverContext=" + this.getServerContext() + ", cdiService=" + this.getCdiService() + ", storeService=" + this.getStoreService() + ", cdiProperties=" + this.getCdiProperties() + ", ftpMaxLogin=" + this.getFtpMaxLogin() + ", applicationContext=" + this.getApplicationContext() + ")";
    }
}

