/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hanshow.cdi.core.FileLineSorter;
import com.hanshow.cdi.core.PathHelper;
import com.hanshow.cdi.io.KeyedLine;
import com.hanshow.cdi.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UploadedFile {
    private static final Logger log = LogManager.getLogger(UploadedFile.class);
    private static final String CHECKSUM_FILENAME = "checksum";
    private long id = Utils.createId();
    private File rootDir;
    private File temporaryDir;
    private String userName;
    private String workingDir;
    private String fileName;
    private File absoluteFile;
    private File sortedFile;
    private File processingFile;
    private File backupFile;
    private String storeCode;
    private String customerStoreCode;
    private Set<String> serverUrl;
    private int serverId;
    private String taskName;
    private String sku;

    public UploadedFile(String userName, String taskName, String workingDir, String fileName, File rootDir, File temporaryDir, Set<String> serverUrl, int serverId) {
        this.setRootDir(rootDir);
        this.temporaryDir = temporaryDir;
        this.userName = userName;
        this.taskName = taskName;
        this.workingDir = workingDir;
        this.fileName = fileName;
        this.serverUrl = serverUrl;
        this.absoluteFile = PathHelper.getUserUploadedFile(rootDir, userName, workingDir, fileName);
        this.backupFile = PathHelper.getUserHistoryFile(rootDir, userName, workingDir, fileName);
        this.serverId = serverId;
        this.getStoreByFilename();
    }

    public UploadedFile(String userName, String taskName, String workingDir, String fileName, File rootDir, File temporaryDir, Set<String> serverUrl, String sku) {
        this.setRootDir(rootDir);
        this.temporaryDir = temporaryDir;
        this.userName = userName;
        this.taskName = taskName;
        this.workingDir = workingDir;
        this.fileName = fileName;
        this.serverUrl = serverUrl;
        this.absoluteFile = PathHelper.getUserUploadedFile(rootDir, userName, workingDir, fileName);
        this.backupFile = PathHelper.getUserHistoryFile(rootDir, userName, workingDir, fileName);
        this.sku = sku;
        this.getStoreByFilename();
    }

    public UploadedFile(String taskName, String workingDir, String fileName, File rootDir, File temporaryDir, Set<String> serverUrl, String sku) {
        this.setRootDir(rootDir);
        this.temporaryDir = temporaryDir;
        this.taskName = taskName;
        this.workingDir = workingDir;
        this.fileName = fileName;
        this.serverUrl = serverUrl;
        this.absoluteFile = PathHelper.getFileUploadedFile(rootDir, taskName, workingDir, fileName.replace(".hanshow_msg", ""));
        this.backupFile = PathHelper.getUserHistoryFile(rootDir, taskName, workingDir, fileName);
        this.sku = sku;
        this.getStoreByFilename();
    }

    private void getStoreByFilename() {
        try {
            this.storeCode = this.fileName.split("-")[2];
            this.customerStoreCode = this.fileName.split("-")[1];
        }
        catch (Exception e) {
            throw new IllegalArgumentException("This file is not integration file " + this.fileName, e);
        }
    }

    private void getStoreInfo() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.absoluteFile));){
            Map<String, Object> map;
            String line = reader.readLine();
            try {
                map = Utils.parseToMap(line);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("parse line to JSON error." + line, e);
            }
            this.storeCode = (String)map.get("storeCode");
            if (this.storeCode == null) {
                throw new IllegalArgumentException("\"storeCode\" cannot be found in uploaded file: " + this.absoluteFile.getAbsolutePath());
            }
            this.customerStoreCode = (String)map.get("customerStoreCode");
            if (this.customerStoreCode == null) {
                throw new IllegalArgumentException("\"customerStoreCode\" cannot be found in uploaded file: " + this.absoluteFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("uploaded file IO error: " + this.absoluteFile, e);
        }
    }

    public String toString() {
        return this.absoluteFile.getAbsolutePath();
    }

    public boolean validateBackup() {
        try {
            String previousChecksum;
            if (!this.backupFile.exists()) {
                return false;
            }
            File checksum = new File(this.backupFile.getParent(), CHECKSUM_FILENAME);
            if (!checksum.exists()) {
                return false;
            }
            try (BufferedReader reader = Files.newBufferedReader(Paths.get(checksum.getAbsolutePath(), new String[0]));){
                previousChecksum = reader.readLine();
            }
            String caculatedChecksum = Utils.checksumFile(this.backupFile);
            return caculatedChecksum.equalsIgnoreCase(previousChecksum);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void backup() throws Exception {
        Utils.copyFile(this.sortedFile, this.backupFile);
        String checksum = Utils.checksumFile(this.backupFile);
        File file = new File(this.backupFile.getParent(), CHECKSUM_FILENAME);
        try (FileOutputStream os = new FileOutputStream(file);){
            ((OutputStream)os).write(checksum.getBytes());
        }
        this.sortedFile.delete();
    }

    private void getFile(File f1, File f2) throws IOException {
        JSONObject map;
        String line2;
        LinkedHashMap<String, String> map1 = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>();
        BufferedReader bufferedReader1 = new BufferedReader(new FileReader(f1));
        BufferedReader bufferedReader2 = new BufferedReader(new FileReader(f2));
        if (!bufferedReader1.ready() && f1.length() != 0L) {
            return;
        }
        if (!bufferedReader2.ready() && f2.length() != 0L) {
            return;
        }
        if (f2.length() == 0L) {
            return;
        }
        while ((line2 = bufferedReader2.readLine()) != null) {
            map = JSON.parseObject((String)line2);
            map2.put(map.get(this.sku).toString(), line2);
        }
        if (f1.length() != 0L) {
            String line1;
            while ((line1 = bufferedReader1.readLine()) != null) {
                map = JSON.parseObject((String)line1);
                map1.put(map.get(this.sku).toString(), line1);
            }
        }
        bufferedReader1.close();
        bufferedReader2.close();
        HashMap map3 = new HashMap(map1);
        Set list = map1.keySet();
        map1.putAll(map2);
        boolean i = false;
        boolean result = true;
        for (Map.Entry entry : map3.entrySet()) {
            if (!list.contains(entry.getKey()) || ((String)map1.get(entry.getKey())).equals(entry.getValue())) continue;
            String str = (String)map1.remove(entry.getKey());
            UploadedFile.changeLine(str, (String)entry.getValue());
            result = false;
        }
        map1.entrySet().removeAll(map3.entrySet());
        for (Map.Entry entry : map1.entrySet()) {
            UploadedFile.space((String)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeLine(String newStr, String oldStr) {
        String path = "C:\\Users\\zhangweijian\\Desktop\\previous3";
        RandomAccessFile raf = null;
        File tmp = null;
        FileOutputStream tmpOut = null;
        FileInputStream tmpIn = null;
        try {
            raf = new RandomAccessFile(path, "rw");
            tmp = File.createTempFile("tmp", null);
            tmpOut = new FileOutputStream(tmp);
            tmpIn = new FileInputStream(tmp);
            String line = null;
            long lastPoint = 0L;
            long insertPoint = 0L;
            long nextPoint = 0L;
            boolean result = true;
            while ((line = raf.readLine()) != null) {
                long ponit = raf.getFilePointer();
                if (line.contains(oldStr)) {
                    insertPoint = lastPoint;
                    result = false;
                }
                lastPoint = ponit;
                if (result) continue;
                nextPoint = ponit;
                break;
            }
            raf.seek(nextPoint);
            byte[] bbuf = new byte[2048];
            int hasRead = 0;
            while ((hasRead = raf.read(bbuf)) > 0) {
                tmpOut.write(bbuf, 0, hasRead);
            }
            raf.seek(insertPoint);
            if (line != null) {
                if (newStr.getBytes().length - oldStr.getBytes().length > 0) {
                    raf.readLine();
                    raf.setLength(raf.getFilePointer());
                    raf.seek(insertPoint);
                } else {
                    raf.setLength(raf.getFilePointer());
                    raf.seek(insertPoint);
                }
                raf.writeBytes(line.replace(oldStr, newStr) + "\n");
            }
            while ((hasRead = tmpIn.read(bbuf)) > 0) {
                raf.write(bbuf, 0, hasRead);
            }
            tmp.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (tmpIn != null) {
                    tmpIn.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (tmpOut != null) {
                    tmpOut.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void space(String line) {
        OutputStreamWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(new File("C:\\Users\\zhangweijian\\Desktop\\previous3"), true);
            fileWriter.write(line + "\r\n");
            fileWriter.flush();
        }
        catch (Exception e) {
            log.error("reader log error", (Throwable)e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void clean() {
        this.processingFile.delete();
    }

    public void createProcessingFile() throws Exception {
        this.processingFile = new File(this.temporaryDir, this.fileName + '-' + Long.toString(this.id));
        Utils.copyFile(this.absoluteFile, this.processingFile);
    }

    public void sort(KeyedLine<?> keyedLine) throws Exception {
        this.sortedFile = new File(this.temporaryDir, this.fileName + '-' + Long.toString(this.id));
        FileLineSorter.sort(this.absoluteFile, this.sortedFile, this.temporaryDir, keyedLine);
    }

    public void quickSort(String recordKey) throws Exception {
        this.sortedFile = new File(this.temporaryDir, this.fileName + '-' + this.id);
        FileLineSorter.kunSort(this.absoluteFile, this.sortedFile, this.temporaryDir, recordKey);
    }

    public long getId() {
        return this.id;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public File getTemporaryDir() {
        return this.temporaryDir;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String getFileName() {
        return this.fileName;
    }

    public File getAbsoluteFile() {
        return this.absoluteFile;
    }

    public File getSortedFile() {
        return this.sortedFile;
    }

    public File getProcessingFile() {
        return this.processingFile;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public String getStoreCode() {
        return this.storeCode;
    }

    public String getCustomerStoreCode() {
        return this.customerStoreCode;
    }

    public Set<String> getServerUrl() {
        return this.serverUrl;
    }

    public int getServerId() {
        return this.serverId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getSku() {
        return this.sku;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public void setTemporaryDir(File temporaryDir) {
        this.temporaryDir = temporaryDir;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setAbsoluteFile(File absoluteFile) {
        this.absoluteFile = absoluteFile;
    }

    public void setSortedFile(File sortedFile) {
        this.sortedFile = sortedFile;
    }

    public void setProcessingFile(File processingFile) {
        this.processingFile = processingFile;
    }

    public void setBackupFile(File backupFile) {
        this.backupFile = backupFile;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public void setCustomerStoreCode(String customerStoreCode) {
        this.customerStoreCode = customerStoreCode;
    }

    public void setServerUrl(Set<String> serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setServerId(int serverId) {
        this.serverId = serverId;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadedFile)) {
            return false;
        }
        UploadedFile other = (UploadedFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getServerId() != other.getServerId()) {
            return false;
        }
        File this$rootDir = this.getRootDir();
        File other$rootDir = other.getRootDir();
        if (this$rootDir == null ? other$rootDir != null : !((Object)this$rootDir).equals(other$rootDir)) {
            return false;
        }
        File this$temporaryDir = this.getTemporaryDir();
        File other$temporaryDir = other.getTemporaryDir();
        if (this$temporaryDir == null ? other$temporaryDir != null : !((Object)this$temporaryDir).equals(other$temporaryDir)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$workingDir = this.getWorkingDir();
        String other$workingDir = other.getWorkingDir();
        if (this$workingDir == null ? other$workingDir != null : !this$workingDir.equals(other$workingDir)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        File this$absoluteFile = this.getAbsoluteFile();
        File other$absoluteFile = other.getAbsoluteFile();
        if (this$absoluteFile == null ? other$absoluteFile != null : !((Object)this$absoluteFile).equals(other$absoluteFile)) {
            return false;
        }
        File this$sortedFile = this.getSortedFile();
        File other$sortedFile = other.getSortedFile();
        if (this$sortedFile == null ? other$sortedFile != null : !((Object)this$sortedFile).equals(other$sortedFile)) {
            return false;
        }
        File this$processingFile = this.getProcessingFile();
        File other$processingFile = other.getProcessingFile();
        if (this$processingFile == null ? other$processingFile != null : !((Object)this$processingFile).equals(other$processingFile)) {
            return false;
        }
        File this$backupFile = this.getBackupFile();
        File other$backupFile = other.getBackupFile();
        if (this$backupFile == null ? other$backupFile != null : !((Object)this$backupFile).equals(other$backupFile)) {
            return false;
        }
        String this$storeCode = this.getStoreCode();
        String other$storeCode = other.getStoreCode();
        if (this$storeCode == null ? other$storeCode != null : !this$storeCode.equals(other$storeCode)) {
            return false;
        }
        String this$customerStoreCode = this.getCustomerStoreCode();
        String other$customerStoreCode = other.getCustomerStoreCode();
        if (this$customerStoreCode == null ? other$customerStoreCode != null : !this$customerStoreCode.equals(other$customerStoreCode)) {
            return false;
        }
        Set<String> this$serverUrl = this.getServerUrl();
        Set<String> other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !((Object)this$serverUrl).equals(other$serverUrl)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$sku = this.getSku();
        String other$sku = other.getSku();
        return !(this$sku == null ? other$sku != null : !this$sku.equals(other$sku));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadedFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.getServerId();
        File $rootDir = this.getRootDir();
        result = result * 59 + ($rootDir == null ? 43 : ((Object)$rootDir).hashCode());
        File $temporaryDir = this.getTemporaryDir();
        result = result * 59 + ($temporaryDir == null ? 43 : ((Object)$temporaryDir).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $workingDir = this.getWorkingDir();
        result = result * 59 + ($workingDir == null ? 43 : $workingDir.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        File $absoluteFile = this.getAbsoluteFile();
        result = result * 59 + ($absoluteFile == null ? 43 : ((Object)$absoluteFile).hashCode());
        File $sortedFile = this.getSortedFile();
        result = result * 59 + ($sortedFile == null ? 43 : ((Object)$sortedFile).hashCode());
        File $processingFile = this.getProcessingFile();
        result = result * 59 + ($processingFile == null ? 43 : ((Object)$processingFile).hashCode());
        File $backupFile = this.getBackupFile();
        result = result * 59 + ($backupFile == null ? 43 : ((Object)$backupFile).hashCode());
        String $storeCode = this.getStoreCode();
        result = result * 59 + ($storeCode == null ? 43 : $storeCode.hashCode());
        String $customerStoreCode = this.getCustomerStoreCode();
        result = result * 59 + ($customerStoreCode == null ? 43 : $customerStoreCode.hashCode());
        Set<String> $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : ((Object)$serverUrl).hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $sku = this.getSku();
        result = result * 59 + ($sku == null ? 43 : $sku.hashCode());
        return result;
    }
}

