/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.diff;

import com.hanshow.cdi.io.Line;
import com.hanshow.cdi.io.LineReader;

public class Segment {
    private int begin;
    private int end;
    private int length;
    private int consumed;
    private LineReader reader;

    public Segment(int begin, int end, int length, LineReader reader) {
        this.begin = begin;
        this.end = end;
        this.length = length;
        this.consumed = 0;
        this.reader = reader;
        try {
            reader.moveTo(begin);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean hasNext() {
        return this.consumed < this.length;
    }

    public Line nextLine() {
        Line line = null;
        if (this.consumed < this.length) {
            line = this.reader.readLine();
            ++this.consumed;
        }
        return line;
    }

    public int getLineNum() {
        return this.reader.getLineNum();
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.length;
    }
}

