/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.ftp;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.ftpserver.util.IoUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FtpClientWrap
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger(FtpClientWrap.class);
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private FTPClient client = null;
    private String charset;

    public void connectServerPassive(String serverAddr, int port, String username, String password, String charset) throws SocketException, IOException {
        this.connectServer(serverAddr, port, username, password, charset);
        this.client.enterLocalPassiveMode();
    }

    public void connectServer(String serverAddr, int port, String username, String password, String charset) throws SocketException, IOException {
        this.client = new FTPClient();
        this.client.connect(serverAddr, port);
        this.client.login(username, password);
        this.client.setBufferSize(0x100000);
        this.client.setControlEncoding(null == charset ? "UTF-8" : charset);
        this.client.setFileType(2);
        this.client.setDefaultTimeout(30000);
        this.client.enterLocalPassiveMode();
    }

    public void connectServer(String serverAddr, int port, String username, String password, String charset, int time) throws SocketException, IOException {
        this.connectServer(serverAddr, port, username, password, charset);
        this.client.setDefaultTimeout(time);
    }

    public void setEncoding(String encoding) {
        this.client.setControlEncoding(encoding);
    }

    public void setEnterLocalPassivMode() {
        this.client.enterLocalPassiveMode();
    }

    public void setEnterLocalActiveMode() {
        this.client.enterLocalActiveMode();
    }

    public void setFileTypeToBinary() throws IOException {
        this.client.setFileType(2);
    }

    public void setFileTypeToAscii() throws IOException {
        this.client.setFileType(0);
    }

    public boolean closeServer() throws IOException {
        boolean status = false;
        if (this.client != null && this.client.isConnected()) {
            try {
                this.client.logout();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (this.client.isConnected()) {
                    try {
                        this.client.disconnect();
                        status = true;
                    }
                    catch (IOException ioe) {
                        status = false;
                    }
                }
            }
        }
        return status;
    }

    public boolean changeWorkingDirectory(String path) throws IOException {
        return this.client.changeWorkingDirectory(path);
    }

    public boolean makeDirectory(String pathName) throws IOException {
        return this.client.makeDirectory(pathName);
    }

    public boolean removeDirectory(String path) throws IOException {
        return this.client.removeDirectory(path);
    }

    public boolean removeDirectory(String path, boolean isAll) throws IOException {
        if (!isAll) {
            return this.removeDirectory(path);
        }
        FTPFile[] ftpFileArr = this.client.listFiles(path);
        if (ftpFileArr == null || ftpFileArr.length == 0) {
            return this.removeDirectory(path);
        }
        for (FTPFile ftpFile : ftpFileArr) {
            String name = ftpFile.getName();
            if (ftpFile.isDirectory()) {
                this.removeDirectory(path + "/" + name, true);
                continue;
            }
            if (ftpFile.isFile()) {
                this.deleteFile(path + "/" + name);
                continue;
            }
            if (!ftpFile.isSymbolicLink() && !ftpFile.isUnknown()) continue;
        }
        return this.client.removeDirectory(path);
    }

    public boolean existDirectory(String path) throws IOException {
        FTPFile[] remoteFiles;
        boolean flag = false;
        for (FTPFile ftpFile : remoteFiles = this.client.listFiles(path)) {
            if (!ftpFile.isDirectory() || !ftpFile.getName().equalsIgnoreCase(path)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public List<String> getFileList(String path) throws IOException {
        FTPFile[] ftpFiles = this.client.listFiles(path);
        ArrayList<String> retList = new ArrayList<String>();
        if (ftpFiles == null || ftpFiles.length == 0) {
            return retList;
        }
        for (FTPFile ftpFile : ftpFiles) {
            if (!ftpFile.isFile()) continue;
            retList.add(ftpFile.getName());
        }
        return retList;
    }

    public boolean deleteFile(String pathName) throws IOException {
        return this.client.deleteFile(pathName);
    }

    public boolean uploadFile(String localFilePath, String remoteFileName) throws IOException {
        try (FileInputStream is = new FileInputStream(localFilePath);){
            boolean bl = this.client.storeFile(remoteFileName, (InputStream)is);
            return bl;
        }
    }

    public boolean uploadFile(String fileName) throws IOException {
        return this.uploadFile(fileName, fileName);
    }

    public boolean uploadFile(InputStream iStream, String newName) throws IOException {
        return this.client.storeFile(newName, iStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String remoteFileName, String localFileName) throws IOException {
        boolean bl;
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(localFileName);
            bl = this.client.retrieveFile(remoteFileName, (OutputStream)os);
        }
        catch (Throwable throwable) {
            IoUtils.close(os);
            throw throwable;
        }
        IoUtils.close((OutputStream)os);
        return bl;
    }

    public InputStream downloadFile(String sourceFileName) throws IOException {
        return this.client.retrieveFileStream(sourceFileName);
    }

    @Override
    public void close() throws Exception {
        log.info("FtpClient Closed!");
    }
}

