/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.io;

import com.hanshow.cdi.io.Line;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class LineReader
extends Reader {
    private int lineNum = 0;
    private BufferedReader reader;
    private File file;

    public LineReader(File file) throws FileNotFoundException {
        this.file = file;
        this.reader = new BufferedReader(new FileReader(file));
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public Line readLine() {
        try {
            String line = this.reader.readLine();
            if (line == null) {
                return null;
            }
            ++this.lineNum;
            return new Line(this.file, line, this.lineNum);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("unexpected EOF.", ioe);
        }
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public void moveTo(int num) throws IOException {
        if (num < this.lineNum) {
            throw new IllegalStateException(String.format("cannot move backward, current=%d required=%d.", this.lineNum, num));
        }
        for (int i = this.lineNum; i < num; ++i) {
            this.readLine();
        }
    }
}

