/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.hanshow.cdi.json.JsonApi;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class JacksonJsonApi
implements JsonApi {
    private static ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true).configure(SerializationFeature.WRITE_NULL_MAP_VALUES, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true).configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
    private static ObjectMapper controllerObjectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);

    @Override
    public String toJson(Object object) throws Exception {
        return objectMapper.writeValueAsString(object);
    }

    @Override
    public String toJsonString(Object object) throws Exception {
        return controllerObjectMapper.writeValueAsString(object);
    }

    @Override
    public String toJson(Object object, boolean format) throws Exception {
        if (format) {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        return objectMapper.writeValueAsString(object);
    }

    @Override
    public Map<String, Object> parseToMap(String json) throws Exception {
        return (Map)objectMapper.readValue(json, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
    }

    @Override
    public <T> T toBean(String json, Class<T> T) throws Exception {
        Object t = objectMapper.readValue(json, T);
        return (T)t;
    }
}

