/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.service.impl;

import com.hanshow.cdi.core.BatchRecord;
import com.hanshow.cdi.dao.StoresMapper;
import com.hanshow.cdi.service.StoreService;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoreServiceImpl
implements StoreService {
    private static final Logger log = LogManager.getLogger(StoreServiceImpl.class);
    private final StoresMapper dao;

    @Autowired
    public StoreServiceImpl(StoresMapper dao) {
        this.dao = dao;
    }

    @Override
    public void createHistory() {
        this.dao.createHistory();
    }

    @Override
    public int insertHistoryRecord(BatchRecord record) {
        return this.dao.insertHistoryRecord(record.getBatchId(), record.getTaskName(), record.getAmount(), record.getData(), record.getStoreCode(), record.getCustomerStoreCode());
    }

    @Override
    public int updateAfterSend(String batchId, String success, String failed, String taskName) {
        return this.dao.updateAfterSend(batchId, success, failed, taskName);
    }

    @Override
    public List<Map<String, Object>> selectTaskMessage(String taskName, String batchId, int index, int pageSize) {
        return this.dao.selectTaskMessage(taskName, batchId, index, pageSize);
    }

    @Override
    public int selectNum(String taskName, String batchId) {
        return this.dao.selectNum(taskName, batchId);
    }

    @Override
    public Map<String, Object> selectByBatchId(String taskName, String batchId) {
        Map<String, Object> map = this.dao.selectByBatchId(taskName, batchId);
        map.put("taskName", taskName);
        return map;
    }

    @Override
    public int deleteByDay(int day) {
        return this.dao.deleteByDay(day);
    }

    @Override
    public int deleteByBatchId(String taskName, String batchId) {
        return this.dao.deleteByBatchId(taskName, batchId);
    }

    @Override
    public int deleteTable(String taskName) {
        return this.dao.deleteTable(taskName);
    }
}

