/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.sftp;

import com.hanshow.cdi.listener.SftpFileUploadedListener;
import com.hanshow.cdi.sftp.Authcator;
import com.hanshow.cdi.sftp.SftpUser;
import com.hanshow.cdi.sftp.UserManager;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.subsystem.sftp.SftpEventListener;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;

public class SftpServerWrap {
    private InetSocketAddress address;
    private SshServer sshd;

    public SftpServerWrap(InetSocketAddress address) {
        this.address = address;
        this.sshd = null;
    }

    private void prepareUserHome(UserManager userManager) throws IOException {
        Set<String> sftpUsers = userManager.getAllUserNames();
        for (String username : sftpUsers) {
            SftpUser user = userManager.getUserByUserName(username);
            File home = new File(user.getWorkingDir());
            if (home.exists()) {
                if (!home.isDirectory()) {
                    throw new IOException(String.format("home directory %s of user %s exists, but not a directory.", home, username));
                }
                if (home.canWrite()) continue;
                throw new IOException(String.format("home directory %s of user %s exists, but hasn't write permission.", home, username));
            }
            if (home.mkdirs()) continue;
            throw new IOException(String.format("home directory %s of user %s isn't exists, but no permission to create it.", home, username));
        }
    }

    public synchronized void start(Properties ftpUsersProp, SftpFileUploadedListener sftpEventListener, Set<String> sftpUsers) throws IOException {
        this.sshd = SshServer.setUpDefaultServer();
        Authcator au = new Authcator(this.sshd, ftpUsersProp);
        UserManager userManager = new UserManager(sftpUsers, ftpUsersProp);
        this.prepareUserHome(userManager);
        this.sshd.setPort(this.address.getPort());
        SimpleGeneratorHostKeyProvider simpleGeneratorHostKeyProvider = new SimpleGeneratorHostKeyProvider(new File("key.pem"));
        simpleGeneratorHostKeyProvider.setAlgorithm("RSA");
        this.sshd.setKeyPairProvider((KeyPairProvider)simpleGeneratorHostKeyProvider);
        ArrayList<UserAuthPasswordFactory> userAuthFactories = new ArrayList<UserAuthPasswordFactory>();
        userAuthFactories.add(new UserAuthPasswordFactory());
        this.sshd.setUserAuthFactories(userAuthFactories);
        this.sshd.setPasswordAuthenticator((PasswordAuthenticator)au);
        this.sshd.setCommandFactory((CommandFactory)new ScpCommandFactory());
        ArrayList<SftpSubsystemFactory> namedFactoryList = new ArrayList<SftpSubsystemFactory>();
        SftpSubsystemFactory sftpSubsystemFactory = new SftpSubsystemFactory();
        sftpSubsystemFactory.addSftpEventListener((SftpEventListener)sftpEventListener);
        namedFactoryList.add(sftpSubsystemFactory);
        this.sshd.setSubsystemFactories(namedFactoryList);
        this.sshd.start();
    }

    public synchronized void stop() throws IOException {
        if (this.sshd != null && !this.sshd.isClosed()) {
            this.sshd.stop();
        }
        this.sshd = null;
    }
}

