/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.util;

import com.hanshow.cdi.io.Line;
import com.hanshow.cdi.io.LineReader;
import com.hanshow.cdi.util.JsonUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileUtils {
    public static List<File> createChunkFiles(File inputFile, File tmpDir, int chunkSize) throws IOException {
        ArrayList<File> chunkFiles = new ArrayList<File>();
        try (LineReader reader = new LineReader(inputFile);){
            List<Object> lines;
            while ((lines = FileUtils.readLines(reader, chunkSize)) != null) {
                File chunkFile = File.createTempFile("chunk_", ".tmp", tmpDir);
                try (PrintWriter writer = new PrintWriter(new FileWriter(chunkFile));){
                    lines.forEach(writer::println);
                    writer.flush();
                }
                chunkFiles.add(chunkFile);
            }
        }
        return chunkFiles;
    }

    public static void sortChunkFile(File chunkFile, String recordKey) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(chunkFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        lines.sort((o1, o2) -> {
            Map m1 = new HashMap();
            Map m2 = new HashMap();
            try {
                m1 = JsonUtils.readJson(o1, Map.class);
                m2 = JsonUtils.readJson(o2, Map.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return m1.get(recordKey).toString().compareTo(m2.get(recordKey).toString());
        });
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(chunkFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
    }

    private static <T> List<T> readLines(LineReader reader, int maxLines) {
        Line line;
        ArrayList<String> lines = null;
        for (int num = 0; num < maxLines && (line = reader.readLine()) != null; ++num) {
            if (lines == null) {
                lines = new ArrayList<String>();
            }
            lines.add(line.getText());
        }
        return lines;
    }

    public static class ChunkReader
    implements Closeable {
        private final BufferedReader reader;
        private String recordKey;
        private File file;
        private String currentLineWithKey;

        public String getCurrentLineWithKey() {
            return this.currentLineWithKey;
        }

        public ChunkReader(File chunkFile, String recordKey) throws IOException {
            this.file = chunkFile;
            this.reader = new BufferedReader(new InputStreamReader(Files.newInputStream(chunkFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            this.recordKey = recordKey;
            this.currentLineWithKey = this.readNextLine();
        }

        public boolean existNext() throws IOException {
            return this.currentLineWithKey != null;
        }

        public boolean hasNext() throws IOException {
            if (this.currentLineWithKey == null) {
                return false;
            }
            String nextLineWithKey = this.readNextLine();
            if (nextLineWithKey != null) {
                this.currentLineWithKey = nextLineWithKey;
                return true;
            }
            return false;
        }

        public String getCurrentLine() {
            return this.currentLineWithKey.substring(this.currentLineWithKey.indexOf(",") + 1);
        }

        private String readNextLine() throws IOException {
            String line = this.reader.readLine();
            if (line == null) {
                this.close();
                return null;
            }
            Map map = JsonUtils.readJson(line, Map.class);
            String key = map.containsKey(this.recordKey) ? map.get(this.recordKey).toString() : "";
            return key + "," + line;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
            this.file.delete();
        }
    }
}

