/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.util;

import com.hanshow.cdi.config.AkSkConfig;
import com.hanshow.cdi.util.HSIAM1TokenGenerator;
import com.hanshow.cdi.util.SpringApplicationContextProvider;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

public class OkHttpsCertClientWrap {
    private static final Logger log = LogManager.getLogger(OkHttpsCertClientWrap.class);
    private OkHttpClient httpsClient = null;
    private static final String JSON_MEDIA_TYPE_PATTERN = "application/json; charset=%s";
    private static SSLSocketFactory sslSocketFactory;
    private static String CERTIFICATE_NAME;
    private static String KEYPASS;
    private static String STOREPASS;

    public OkHttpsCertClientWrap(int timeout, String certificateName, String keyPass, String storePass) {
        try {
            CERTIFICATE_NAME = certificateName;
            KEYPASS = keyPass;
            STOREPASS = storePass;
            OkHttpsCertClientWrap.initSSL();
            this.httpsClient = this.setSSL(timeout);
        }
        catch (Exception e) {
            log.error("Create https sender error ", (Throwable)e);
        }
    }

    private static void initSSL() {
        try {
            sslSocketFactory = SSLUtils.createSSLSocketFactory(KEYPASS, STOREPASS);
        }
        catch (Exception e) {
            log.error("initSSL error", (Throwable)e);
        }
    }

    private OkHttpClient setSSL(int timeout) {
        return new OkHttpClient().newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)new HttpsTrustManager()).hostnameVerifier((HostnameVerifier)new HttpsTrustManager.TrustAllHostnameVerifier()).connectTimeout((long)timeout, TimeUnit.SECONDS).readTimeout((long)timeout, TimeUnit.SECONDS).writeTimeout((long)timeout, TimeUnit.SECONDS).build();
    }

    public String postJsonToURLByAkSk(String url, String string, String charset, String customer, String store) throws IOException, InvalidKeyException {
        return this.postJsonToURLByAkSk(url, string, charset, customer, store, false);
    }

    public String postJsonToURLByAkSk(String url, String string, String charset, String customer, String store, boolean gzip) throws IOException, InvalidKeyException {
        Request request;
        byte[] bytes;
        if (gzip) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zipper = new GZIPOutputStream(baos);
            ((OutputStream)zipper).write(string.getBytes(charset));
            ((OutputStream)zipper).close();
            bytes = baos.toByteArray();
        } else {
            bytes = string.getBytes(charset);
        }
        MediaType JSON2 = MediaType.parse((String)String.format(JSON_MEDIA_TYPE_PATTERN, charset));
        RequestBody body = RequestBody.create((MediaType)JSON2, (byte[])bytes);
        String realStore = store.split("-")[0];
        AkSkConfig akSkConfig = SpringApplicationContextProvider.getBean(AkSkConfig.class);
        if (gzip) {
            if (akSkConfig.getSwitcher().booleanValue()) {
                String token = new HSIAM1TokenGenerator("POST", customer, realStore).generate(akSkConfig.getAccessKey(), akSkConfig.getSecretKey());
                request = new Request.Builder().url(url).post(body).header("Content-Encoding", "gzip").header("Authorization", token).build();
            } else {
                request = new Request.Builder().url(url).post(body).header("Content-Encoding", "gzip").build();
            }
        } else if (akSkConfig.getSwitcher().booleanValue()) {
            String token = new HSIAM1TokenGenerator("POST", customer, realStore).generate(akSkConfig.getAccessKey(), akSkConfig.getSecretKey());
            request = new Request.Builder().url(url).post(body).header("Authorization", token).build();
        } else {
            request = new Request.Builder().url(url).post(body).build();
        }
        Response response = this.httpsClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        if (response.code() == 401) {
            response.close();
            throw new InvalidKeyException(String.format("Unauthorized: %s, Valid Ak/Sk Required.", response.code()));
        }
        log.warn("Post JSON to url [{}] got unexpected code [{}] message [{}] DATA [{}]", (Object)url, (Object)response.code(), (Object)response.message(), (Object)string);
        log.warn(response.body().string());
        throw new IOException("Post JSON to url got unexpected");
    }

    public String postJsonToURL(String url, String string, String charset) throws IOException {
        return this.postJsonToURL(url, string, charset, false);
    }

    public String postJsonToURL(String url, String string, String charset, boolean gzip) throws IOException {
        byte[] bytes;
        if (gzip) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zipper = new GZIPOutputStream(baos);
            ((OutputStream)zipper).write(string.getBytes(charset));
            ((OutputStream)zipper).close();
            bytes = baos.toByteArray();
        } else {
            bytes = string.getBytes(charset);
        }
        MediaType JSON2 = MediaType.parse((String)String.format(JSON_MEDIA_TYPE_PATTERN, charset));
        RequestBody body = RequestBody.create((MediaType)JSON2, (byte[])bytes);
        Request request = gzip ? new Request.Builder().url(url).post(body).header("Content-Encoding", "gzip").build() : new Request.Builder().url(url).post(body).build();
        Response response = this.httpsClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        log.warn("Post JSON to url [{}] got unexpected code [{}] message [{}] DATA [{}]", (Object)url, (Object)response.code(), (Object)response.message(), (Object)string);
        log.warn(response.body().string());
        throw new IOException("Post JSON to url got unexpected");
    }

    public String getURL(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response response = this.httpsClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        response.close();
        throw new IOException(String.format("get to url %s got unexpected code %d message %s", url, response.code(), response.message()));
    }

    public String getUrl(String url, String charset) throws IOException {
        return this.getUrl(url, charset, false);
    }

    public String getUrl(String url, String charset, boolean gzip) throws IOException {
        Request request = gzip ? new Request.Builder().url(url).get().header("Content-Encoding", "gzip").build() : new Request.Builder().url(url).get().build();
        Response response = this.httpsClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        response.close();
        throw new IOException(String.format("get JSON to url %s got unexpected code %d", url, response.code()));
    }

    static {
        CERTIFICATE_NAME = null;
        KEYPASS = null;
        STOREPASS = null;
    }

    static class SSLUtils {
        SSLUtils() {
        }

        public static KeyStore loadKeyStore(String type, String password) throws Exception {
            try (FileInputStream input = new FileInputStream(new ClassPathResource(CERTIFICATE_NAME).getFile());){
                if (input == null) {
                    throw new FileNotFoundException("cannot find KeyStore file " + CERTIFICATE_NAME);
                }
                KeyStore ks = KeyStore.getInstance(type);
                ks.load(input, password.toCharArray());
                KeyStore keyStore = ks;
                return keyStore;
            }
        }

        public static SSLSocketFactory createSSLSocketFactory(String protocol, String algorithm, String provider, String keyPassword, String keyStoreType, String storePassword) throws Exception {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm, provider);
            KeyStore keyStore = SSLUtils.loadKeyStore(keyStoreType, storePassword);
            keyManagerFactory.init(keyStore, keyPassword.toCharArray());
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagers, new SecureRandom());
            return sslContext.getSocketFactory();
        }

        public static SSLSocketFactory createSSLSocketFactory(String keyPassword, String storePassword) throws Exception {
            return SSLUtils.createSSLSocketFactory("TLS", "SunX509", "SunJSSE", keyPassword, "JKS", storePassword);
        }

        public static HostnameVerifier createHostnameVerifier() {
            return (hostname, session) -> true;
        }
    }

    static class HttpsTrustManager
    implements X509TrustManager {
        HttpsTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public static SSLSocketFactory createSSLSocketFactory() {
            SSLSocketFactory sSLSocketFactory = null;
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, new TrustManager[]{new HttpsTrustManager()}, new SecureRandom());
                sSLSocketFactory = sc.getSocketFactory();
            }
            catch (Exception e) {
                log.error("createSSLSocketFactory error", (Throwable)e);
            }
            return sSLSocketFactory;
        }

        public static class TrustAllHostnameVerifier
        implements HostnameVerifier {
            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        }
    }
}

