/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadConfig {
    private static final Logger log = LoggerFactory.getLogger(ReadConfig.class);

    public static String read(File path) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(path));
        if (!bufferedReader.ready()) {
            System.out.println("\u6587\u4ef6\u6d41\u6682\u65f6\u65e0\u6cd5\u8bfb\u53d6");
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line);
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static void write(String line) throws IOException, ConfigurationException {
        PropertiesConfiguration p = new PropertiesConfiguration("length.properties");
        File file = new File(p.getFile().getParent(), "cdi");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(line);
        bufferedWriter.close();
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            log.debug("delete file : [{}]", (Object)file.getName());
            if (!file.delete()) {
                log.debug("delete file : [{}] failed", (Object)file.getName());
            }
        }
    }
}

