/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.hanshow.cdi.json.JacksonJsonApi;
import com.hanshow.cdi.json.JsonApi;
import com.hanshow.cdi.util.JsonUtils;
import com.hanshow.cdi.util.UnicodeFilterUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.springframework.stereotype.Component;

@Component
public class Utils {
    private static AtomicInteger sequence = new AtomicInteger(0);
    private static JsonApi jsonAPI = new JacksonJsonApi();

    public static long createId() {
        int sequ = sequence.getAndIncrement();
        long prefix = System.currentTimeMillis() << 16;
        long suffix = sequ & 0xFFFF;
        long taskId = prefix | suffix;
        return taskId;
    }

    public static <T> T stringToItem(String args, TypeReference<T> typeReference) throws Exception {
        return JsonUtils.readJson(args, typeReference);
    }

    public static <T> T stringToItem(String args, Class<T> clazz) throws Exception {
        return JsonUtils.readJson(args, clazz);
    }

    public static void main(String[] args) {
        System.out.println(Utils.createId());
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String checksumFile(String pathname) throws Exception {
        return Utils.checksumFile(new File(pathname));
    }

    public static String checksumFile(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        try (FileInputStream is = new FileInputStream(file);
             DigestInputStream dis = new DigestInputStream(is, md);){
            IOUtils.copy((InputStream)dis, (OutputStream)new NullOutputStream());
        }
        return Utils.toHexString(md.digest());
    }

    public static void copyFile(File src, File target) throws IOException {
        target.getParentFile().mkdirs();
        try (InputStream is = Files.newInputStream(src.toPath(), new OpenOption[0]);
             OutputStream os = Files.newOutputStream(target.toPath(), new OpenOption[0]);){
            IOUtils.copyLarge((InputStream)is, (OutputStream)os);
        }
    }

    public static <T> T toBean(String json, Class<T> T) throws Exception {
        return jsonAPI.toBean(json, T);
    }

    public static String toJson(Object object) throws Exception {
        return jsonAPI.toJson(object);
    }

    public static String toJsonString(Object object) throws Exception {
        return jsonAPI.toJsonString(object);
    }

    public static String toJson(Object object, boolean format) throws Exception {
        return jsonAPI.toJson(object, format);
    }

    public static Map<String, Object> parseToMapUnicode(String json) throws Exception {
        try {
            jsonAPI.parseToMap(json);
            json = UnicodeFilterUtils.replaceAsciiControl(json);
        }
        catch (Exception e) {
            json = UnicodeFilterUtils.removeAsciiControl(json);
        }
        return jsonAPI.parseToMap(json);
    }

    public static Map<String, Object> parseToMap(String json) throws Exception {
        return jsonAPI.parseToMap(json);
    }

    public static void sleep(long millis) {
        if (millis <= 0L) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

