/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart;

import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.Http11NioProtocol;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TomcatConfig {
    @Value(value="${http.port}")
    private int httpPort;
    @Value(value="${server.tomcat.max-connections}")
    private int maxConnections;
    @Value(value="${server.tomcat.threads.max}")
    private int maxThreads;
    @Value(value="${server.tomcat.threads.min-spare}")
    private int minThreads;
    @Value(value="${server.tomcat.accept-count}")
    private int acceptCount;
    @Value(value="${server.tomcat.connection-timeout}")
    private int connectionTimeout;

    @Bean
    public ServletWebServerFactory servletContainer() {
        TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
        tomcat.addAdditionalTomcatConnectors(this.createStandardConnector());
        return tomcat;
    }

    private Connector createStandardConnector() {
        Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
        connector.setPort(this.httpPort);
        Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
        protocol.setMaxConnections(this.maxConnections);
        protocol.setMaxThreads(this.maxThreads);
        protocol.setMinSpareThreads(this.minThreads);
        protocol.setAcceptCount(this.acceptCount);
        protocol.setConnectionTimeout(this.connectionTimeout);
        return connector;
    }
}

