/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart;

import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TomcatCustomizer
implements WebServerFactoryCustomizer<TomcatServletWebServerFactory> {
    private static final Logger log = LogManager.getLogger(TomcatCustomizer.class);
    @Value(value="${server.tomcat.connection-timeout}")
    private int connectionTimeout;
    @Value(value="${server.tomcat.keep-alive-timeout}")
    private int keepAliveTimeout;

    @Override
    public void customize(TomcatServletWebServerFactory factory) {
        factory.addConnectorCustomizers(connector -> {
            Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
            protocol.setConnectionTimeout(this.connectionTimeout);
            protocol.setKeepAliveTimeout(this.keepAliveTimeout);
            log.info("####################################################################################");
            log.info("# TomcatCustomizer");
            log.info("# port {}", (Object)protocol.getPort());
            log.info("# MaxConnections {}", (Object)protocol.getMaxConnections());
            log.info("# AcceptorThreadCount {}", (Object)protocol.getAcceptorThreadCount());
            log.info("# AcceptCount {}", (Object)protocol.getAcceptCount());
            log.info("# MaxThread {}", (Object)protocol.getMaxThreads());
            log.info("# MinSpareThreads {}", (Object)protocol.getMinSpareThreads());
            log.info("# ConnectionTimeout {}", (Object)protocol.getConnectionTimeout());
            log.info("# KeepAliveTimeout {}", (Object)protocol.getKeepAliveTimeout());
            log.info("# MaxKeepAliveRequests {}", (Object)protocol.getMaxKeepAliveRequests());
            log.info("# MaxSavePostSize {}", (Object)protocol.getMaxSavePostSize());
            log.info("####################################################################################");
        });
    }
}

