/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.api.v1;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hanshow.intsmart.service.CustomerDataService;
import com.hanshow.intsmart.service.PrismartAgentService;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
@RequestMapping(value={"/proxy"})
public class ProxyV1Controller {
    private static final Logger log = LogManager.getLogger(ProxyV1Controller.class);
    @Autowired
    CustomerDataService customerDataService;
    @Autowired
    PrismartAgentService prismartAgentService;

    @ApiOperation(value="Integration Proxy API", notes="\u6807\u51c6\u5bf9\u63a5\u63a5\u53e3API")
    @RequestMapping(value={"/{customer}/integration"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    public Object integration(@RequestBody Map<String, Object> items, @PathVariable String customer) throws InterruptedException {
        log.info("----------------------------- customer {} post data ----------------------------- ", (Object)customer);
        DeferredResult<JSONObject> result = new DeferredResult<JSONObject>();
        result.setResult(JSON.parseObject("{\n  \"resultCode\" : 1001,\n  \"result\" : \"succeed\",\n  \"message\" : \"success\",\n  \"data\" : \"INTEGRATION_CODE_SUCCESS\"\n} "));
        this.customerDataService.processData(items);
        return result;
    }

    @ApiOperation(value="ogi API", notes="ogi\u8f6c\u53d1API")
    @RequestMapping(value={"/{customer}/ogi/**"}, method={RequestMethod.GET}, produces={"application/json;charset=utf-8"})
    public String ogi(@PathVariable String customer, HttpServletRequest request) throws InterruptedException {
        log.info("----------------------------- customer {} post data ----------------------------- ", (Object)customer);
        log.info("----------------------------- request {}  ----------------------------- ", (Object)request.getRequestURL());
        return this.prismartAgentService.forwarding(request.getRequestURL().toString());
    }
}

