/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.api.v2;

import com.hanshow.intsmart.api.ShopWebApiResponse;
import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;
import com.hanshow.intsmart.service.CustomerDataService;
import com.hanshow.intsmart.service.PrismartAgentService;
import com.hanshow.intsmart.util.JsonUtils;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/proxy"})
public class ProxyV2Controller {
    private static final Logger log = LogManager.getLogger(ProxyV2Controller.class);
    @Autowired
    CustomerDataService customerDataService;
    @Autowired
    PrismartAgentService prismartAgentService;

    @ApiOperation(value="Integration Proxy API", notes="\u6807\u51c6\u5bf9\u63a5\u63a5\u53e3API")
    @RequestMapping(value={"/integration/{taskName}/{customerStoreCode}/{storeCode}"}, method={RequestMethod.POST})
    public Object integration1(@RequestBody String args, @PathVariable String taskName, @PathVariable String customerStoreCode, @PathVariable String storeCode) throws Exception {
        log.info("================================RECEIVED REQUEST=====================================");
        log.info("taskName : {}, customerStoreCode: {} ,storeCode: {}", (Object)taskName, (Object)customerStoreCode, (Object)storeCode);
        Long start = System.currentTimeMillis();
        Object result = "";
        log.debug("REQUEST BODY  : {}", (Object)args);
        try {
            result = this.customerDataService.processData(args, taskName);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result = ProxyV2Controller.fail(ShopWebApiResultCodeEnum.CDI_FAILED);
        }
        Long end = System.currentTimeMillis();
        log.info("Response finished! Time consuming :{}ms", (Object)(end - start));
        log.info("====================================RESPONSE========================================");
        try {
            return JsonUtils.readMap(result.toString());
        }
        catch (Exception e) {
            return result;
        }
    }

    public static ShopWebApiResponse fail(ShopWebApiResultCodeEnum resultCode) {
        return new ShopWebApiResponse(resultCode);
    }
}

