/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.api.webui;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.hanshow.cdi.common.ReloadTypeEnum;
import com.hanshow.cdi.core.CdiMode;
import com.hanshow.cdi.core.IntegrationMode;
import com.hanshow.cdi.core.ServerMode;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.cdi.util.JsonUtils;
import com.hanshow.intsmart.api.vo.CdiSystemVo;
import com.hanshow.intsmart.api.vo.CertificateVo;
import com.hanshow.intsmart.api.webui.AbstractController;
import com.hanshow.intsmart.enums.OptionEnum;
import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;
import com.hanshow.intsmart.exception.ApiException;
import com.hanshow.intsmart.model.cache.CustomerCache;
import com.hanshow.intsmart.model.common.GlobalVariables;
import com.hanshow.intsmart.model.entity.Field;
import com.hanshow.intsmart.scheduler.JobExcuteScheduler;
import com.hanshow.intsmart.util.CronUtil;
import com.hanshow.intsmart.util.PropertiesUtil;
import com.hanshow.intsmart.util.UrlUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/intsmart"})
public class DataController
extends AbstractController {
    private static final Logger log = LogManager.getLogger(DataController.class);
    @Value(value="${task.single-execution-min-time-interval:60}")
    private int singleExecutionMinTimeInterval;

    @PostMapping(value={"/certificate"})
    public Object uploadCertificate(@RequestParam(value="certificate", required=false) MultipartFile certificate, CertificateVo certificateVo) throws Exception {
        log.info("========================== upload certificate ==========================");
        certificateVo.setCertificate(certificate);
        AbstractController.ArgumentsValidator validator = () -> {
            log.info("request={}", (Object)certificateVo);
            if (certificateVo.getCustomerCode() == null) {
                throw new IllegalArgumentException("customerCode cannot be null");
            }
            if (certificateVo.getCertificateName() == null) {
                throw new IllegalArgumentException("certificateName cannot be null");
            }
            certificateVo.setType(certificate != null ? "ADD" : "UPDATE");
        };
        AbstractController.APIRoutine routine = () -> this.SaveCertificateProperties(() -> (AbstractController)this.new AbstractController.SaveProperties(certificateVo));
        return this.handle(validator, routine, () -> this.reloadBean(certificateVo.getCustomerCode(), certificateVo.getType()));
    }

    @GetMapping(value={"/certificate"})
    public Object getCertificate(@RequestParam(value="customerCode", required=false) String customerCode) throws JsonProcessingException {
        log.info("========================== get certificate ==========================");
        LinkedHashMap<String, LinkedHashMap> map = new LinkedHashMap<String, LinkedHashMap>();
        LinkedHashMap<String, CdiProperties.Certificate> certificateMap = new LinkedHashMap<String, CdiProperties.Certificate>();
        if (StringUtils.isNotBlank(customerCode)) {
            this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getCertificateMap().forEach((customer, certificate) -> {
                if (customer.contains(customerCode)) {
                    certificateMap.put((String)customer, (CdiProperties.Certificate)certificate);
                }
            });
        } else {
            certificateMap.putAll(this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getCertificateMap());
        }
        map.put("certificateMap", JSONObject.parseObject(JsonUtils.toJsonString(certificateMap), LinkedHashMap.class, Feature.OrderedField));
        return map;
    }

    @DeleteMapping(value={"/certificate"})
    public Object deleteCertificate(@RequestBody CertificateVo certificateVo) throws Exception {
        log.info("========================== delete certificate ==========================");
        AbstractController.ArgumentsValidator validator = () -> {
            log.info("request={}", (Object)certificateVo);
            if (certificateVo.getCustomerCode() == null) {
                throw new IllegalArgumentException("customerCode cannot be null");
            }
            if (certificateVo.getCertificateName() == null) {
                throw new IllegalArgumentException("certificateName cannot be null");
            }
            certificateVo.setType("DELETE");
        };
        AbstractController.APIRoutine routine = () -> this.SaveCertificateProperties(() -> (AbstractController)this.new AbstractController.SaveProperties(certificateVo));
        return this.handle(validator, routine, () -> this.reloadBean(certificateVo.getCustomerCode(), certificateVo.getType()));
    }

    @PostMapping(value={"/cdiSystem"}, produces={"application/json;charset=utf-8"})
    public Object cdiSystem(@RequestBody CdiSystemVo cdiSystemForm) throws Exception {
        log.info("========================== change cdiSystem integration ==========================");
        cdiSystemForm.setSenderWorkerNum(this.senderWorkerNum);
        AbstractController.ArgumentsValidator validator = () -> {
            log.info("request={}", (Object)cdiSystemForm);
            if (cdiSystemForm.getMaxNumPerPost() == 0) {
                cdiSystemForm.setMaxNumPerPost(1000);
            }
        };
        AbstractController.APIRoutine routine = () -> this.SaveCdiSystemProperties(() -> (AbstractController)this.new AbstractController.SaveProperties(cdiSystemForm));
        return this.handle(validator, routine, () -> this.reload(ReloadTypeEnum.SYSTEM, null));
    }

    @GetMapping(value={"/cdiSystem"}, produces={"application/json;charset=utf-8"})
    public Object cdiSystem() throws JsonProcessingException {
        log.info("========================== get cdiSystem integration ==========================");
        return new LinkedHashMap(JSONObject.parseObject(JsonUtils.toJsonString(this.initializeContext.getServerContext().getCdiProperties().getCdiSystem()), LinkedHashMap.class, Feature.OrderedField));
    }

    @PostMapping(value={"/task"}, produces={"application/json;charset=utf-8"})
    public Object task(@RequestBody CdiProperties.Task taskForm, @RequestParam(value="originalTaskName") String originalTaskName) throws Exception {
        log.info("========================== task integration ==========================");
        AbstractController.ArgumentsValidator validator = () -> {
            log.info("request = {}", (Object)taskForm);
            if (taskForm.getTaskName() == null) {
                throw new IllegalArgumentException("taskName cannot be null");
            }
            this.structureTask(taskForm);
        };
        AbstractController.APIRoutine routine = () -> {
            if ("".equals(originalTaskName) && this.initializeContext.getServerContext().getTaskMap().containsKey(taskForm.getTaskName())) {
                return ShopWebApiResultCodeEnum.FAILED;
            }
            if (!"".equals(originalTaskName) && !originalTaskName.equals(taskForm.getTaskName())) {
                this.SaveTaskProperties(() -> (AbstractController)this.new AbstractController.SaveProperties(originalTaskName, OptionEnum.DELETE.getName()));
            }
            Object map = this.SaveTaskProperties(() -> (AbstractController)this.new AbstractController.SaveProperties(taskForm, OptionEnum.ADD.getName()));
            return map;
        };
        GlobalVariables.taskNameToStatusUpdatedTime.remove(originalTaskName);
        return this.handle(validator, routine, () -> this.reload(ReloadTypeEnum.ADD_UPDATE, taskForm.getTaskName()));
    }

    @GetMapping(value={"/task"}, produces={"application/json;charset=utf-8"})
    public Object getTask() throws JsonProcessingException {
        log.info("========================== getTask integration ==========================");
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        map.put("task", JSONObject.parseObject(JsonUtils.toJsonString(this.initializeContext.getServerContext().getCdiProperties().getTask()), List.class, Feature.OrderedField));
        return map;
    }

    @DeleteMapping(value={"/task"}, produces={"application/json;charset=utf-8"})
    public Object deleteTask(@RequestBody CdiProperties.Task taskForm) throws Exception {
        log.info("========================== deleteTask integration ==========================");
        AbstractController.ArgumentsValidator validator = () -> {
            log.info("request={}", (Object)taskForm);
            if (taskForm.getTaskName() == null) {
                throw new IllegalArgumentException("taskName cannot be null");
            }
        };
        AbstractController.APIRoutine routine = () -> this.SaveTaskProperties(() -> (AbstractController)this.new AbstractController.SaveProperties(taskForm.getTaskName(), OptionEnum.DELETE.getName()));
        GlobalVariables.taskNameToStatusUpdatedTime.remove(taskForm.getTaskName());
        return this.handle(validator, routine, () -> this.reload(ReloadTypeEnum.DELETE, taskForm.getTaskName()));
    }

    @GetMapping(value={"/tasks/{taskName}/start"})
    public Object start(@PathVariable String taskName) {
        try {
            CdiProperties.Task task = this.initializeContext.getServerContext().getTaskMap().get(taskName);
            String rootDir = this.initializeContext.getServerContext().getRootDir().getAbsolutePath();
            if (task.getDayOrCycle().equals("day")) {
                JobExcuteScheduler.initClientIntegrationJob(task.getTaskName(), task.getDayOrCycle(), CronUtil.getCron(task.getExecuteCycle(), null, null), task.getCdiMode(), task.getStores(), rootDir);
            } else {
                JobExcuteScheduler.initClientIntegrationJob(task.getTaskName(), task.getDayOrCycle(), CronUtil.getCron(task.getExecuteCycle(), task.getStartIntegrationTime(), task.getEndIntegrationTime()), task.getCdiMode(), task.getStores(), rootDir);
            }
            PropertiesUtil.startTask(taskName, this.initializeContext.getServerContext());
            this.writeProperties();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ShopWebApiResultCodeEnum.FAILED);
        }
        return ShopWebApiResultCodeEnum.SUCCEED;
    }

    @GetMapping(value={"/tasks/{taskName}/singleExecution"})
    public Object singleExecution(@PathVariable String taskName, @RequestParam(name="cdiMode", required=false) String cdiMode) {
        if (this.singleExecutionMinTimeInterval < GlobalVariables.singleExecutionMinTimeIntervalInSeconds) {
            this.singleExecutionMinTimeInterval = GlobalVariables.singleExecutionMinTimeIntervalInSeconds;
        }
        long nowTimeStamp = System.currentTimeMillis();
        if (!GlobalVariables.taskNameToStatusUpdatedTime.containsKey(taskName)) {
            GlobalVariables.taskNameToStatusUpdatedTime.put(taskName, nowTimeStamp);
        } else {
            Instant taskInstant = Instant.ofEpochMilli(GlobalVariables.taskNameToStatusUpdatedTime.get(taskName));
            Instant nowInstant = Instant.ofEpochMilli(nowTimeStamp);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
            log.info("Time Stamp For Integration Task [{}] Last Single Execution: {}", (Object)taskName, (Object)formatter.format(taskInstant));
            log.info("Time Stamp For Integration Task [{}] Current Single Execution: {}", (Object)taskName, (Object)formatter.format(nowInstant));
            Duration duration = Duration.ofMillis(nowTimeStamp - GlobalVariables.taskNameToStatusUpdatedTime.get(taskName));
            if (duration.getSeconds() < (long)this.singleExecutionMinTimeInterval) {
                log.warn("Minimum time interval between single executions for task [{}] must be greater than {}s", (Object)taskName, (Object)this.singleExecutionMinTimeInterval);
                throw new ApiException(ShopWebApiResultCodeEnum.I_TOO_MANY_REQUESTS, String.format("Minimum time interval between single executions for task %s must be greater than %ss", taskName, this.singleExecutionMinTimeInterval));
            }
        }
        if (StringUtils.isEmpty(cdiMode)) {
            cdiMode = CdiMode.FIRSTFULL.getName();
        }
        try {
            CdiProperties.Task task = this.initializeContext.getServerContext().getTaskMap().get(taskName);
            String rootDir = this.initializeContext.getServerContext().getRootDir().getAbsolutePath();
            JobExcuteScheduler.initClientSingleExecutionJob(task.getTaskName(), cdiMode, task.getStores(), rootDir);
        }
        catch (SchedulerException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ShopWebApiResultCodeEnum.I_UPDATE_TASK_FAILED, e.getMessage());
        }
        GlobalVariables.taskNameToStatusUpdatedTime.put(taskName, nowTimeStamp);
        return ShopWebApiResultCodeEnum.SUCCEED;
    }

    @GetMapping(value={"/tasks/{taskName}/stop"})
    public Object stop(@PathVariable String taskName) {
        try {
            if (JobExcuteScheduler.stopClientIntegrationJob(taskName)) {
                PropertiesUtil.stopTask(taskName, this.initializeContext.getServerContext());
                this.writeProperties();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ShopWebApiResultCodeEnum.FAILED);
        }
        return ShopWebApiResultCodeEnum.SUCCEED;
    }

    @GetMapping(value={"/batchMsg"}, produces={"application/json;charset=utf-8"})
    public Object getBatchMsg(@RequestParam(value="taskName") String taskName, @RequestParam(value="batchId") String batchId, @RequestParam(value="begin") int begin, @RequestParam(value="pageSize") int pageSize) {
        log.info("========================== getBatchMsg  ==========================");
        ArrayList recordsList = new ArrayList();
        return this.storeService.selectTaskMessage(taskName, batchId, begin, pageSize);
    }

    @GetMapping(value={"/batchNum"}, produces={"application/json;charset=utf-8"})
    public Object getBatchNum(@RequestParam(value="taskName") String taskName, @RequestParam(value="batchId") String batchId) {
        log.info("========================== getBatchMsg  ==========================");
        return this.storeService.selectNum(taskName, batchId);
    }

    @PostMapping(value={"/customer/field"})
    public Object customerData(@RequestBody CdiProperties.Task taskForm) throws Exception {
        log.info("========================== getCustomerData ==========================");
        AbstractController.ArgumentsValidator validator = () -> {
            log.info("request={}", (Object)taskForm);
            if (taskForm.getTaskName() == null) {
                throw new IllegalArgumentException("taskName cannot be null");
            }
        };
        AbstractController.APIRoutine routine = () -> {
            if (IntegrationMode.CLIENT_DATABASE.getName().equals(taskForm.getIntegrationMode())) {
                Map<String, String> map = this.databaseLinkService.getSysColumns(taskForm);
                ArrayList<Field> customerList = new ArrayList<Field>();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    Field field = new Field(entry.getKey(), String.format("%s(%s)", entry.getKey(), entry.getValue()));
                    customerList.add(field);
                }
                CustomerCache.customerMap.put("customerDataList", customerList);
            } else {
                CustomerCache.customerMap.put("customerDataList", new ArrayList());
            }
            return CustomerCache.customerMap;
        };
        return this.handle(validator, routine);
    }

    @PostMapping(value={"/server-address/connect"})
    public Object testServerUrl(@RequestBody String json) {
        log.info("/testServerUrl json : {}", (Object)json);
        JSONObject paramMap = null;
        try {
            paramMap = JSONObject.parseObject(json);
        }
        catch (Exception e) {
            log.warn("testServerUrl JSON\u8f6c\u6362\u5f02\u5e38 : {}", (Object)e.getMessage(), (Object)e);
            throw new ApiException(ShopWebApiResultCodeEnum.I_ILLEGAL_ARGUMENTS);
        }
        if (UrlUtil.testUrl(paramMap.get("url").toString()).booleanValue()) {
            return ShopWebApiResultCodeEnum.SUCCEED;
        }
        throw new ApiException(ShopWebApiResultCodeEnum.FAILED);
    }

    @PostMapping(value={"/database/connect"})
    public Object testDatabase(@RequestBody CdiProperties.Task taskForm) {
        log.info("/testDatabase taskForm : {}", (Object)taskForm);
        if (this.dbUtil.testConnect(taskForm)) {
            return ShopWebApiResultCodeEnum.SUCCEED;
        }
        throw new ApiException(ShopWebApiResultCodeEnum.FAILED);
    }

    @GetMapping(value={"/prismart/field"})
    public Object getPrismartData() {
        if (CustomerCache.shopWebMap.size() == 0) {
            for (ServerMode serverMode : ServerMode.values()) {
                if (serverMode.equals((Object)ServerMode.TOO_MANY_REQUEST)) continue;
                List<Field> shopWebList = this.fieldService.getAllField(serverMode.getName());
                CustomerCache.shopWebMap.put(serverMode.getName(), shopWebList);
            }
        }
        return CustomerCache.shopWebMap;
    }

    @GetMapping(value={"/integration/url"})
    public Map<String, String> getIntegrationUrl() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("\u56fd\u5185All-Star\u73af\u5883", this.integrationUrlProperties.getAllstar());
        map.put("\u56fd\u5185\u878d\u5408\u73af\u5883", this.integrationUrlProperties.getPrismart());
        return map;
    }
}

