/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.api.webui;

import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;
import com.hanshow.intsmart.exception.ApiException;
import com.hanshow.intsmart.model.entity.XsdElement;
import com.hanshow.intsmart.service.XsdParseService;
import com.hanshow.intsmart.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RestController
@RequestMapping(value={"/file"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private InitializeContext initializeContext;
    @Autowired
    private XsdParseService xsdParseService;

    @PostMapping(value={"/upload/xsd/{taskId}"})
    public ResponseEntity<?> uploadXsd(@RequestParam(value="file") MultipartFile file, @PathVariable String taskId) {
        if (file.isEmpty()) {
            return ResponseEntity.badRequest().body("Please upload a .xsd file");
        }
        Path directory = Paths.get("./taskXsd", new String[0]);
        if (Files.notExists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("Failed to create directories: {}", (Object)e.getMessage(), (Object)e);
                return ResponseEntity.internalServerError().body("Failed to create directory for XSD storage.");
            }
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file.getInputStream());
            Element root = document.getDocumentElement();
            XsdElement rootElement = new XsdElement(root.getLocalName(), null);
            this.xsdParseService.traverseNodes(root, rootElement);
            List<String> xsdPaths = this.xsdParseService.convertToPaths(rootElement);
            return ResponseEntity.ok(xsdPaths);
        }
        catch (Exception e) {
            log.error("Failed to analyze the elements of xsd file: {}", (Object)e.getMessage(), (Object)e);
            return ResponseEntity.badRequest().body("Failed to analyze xsd file: " + e.getMessage());
        }
    }

    @PostMapping(value={"/upload"})
    public Object upload(@RequestParam(value="file") List<MultipartFile> files) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (files == null || files.isEmpty()) {
            throw new ApiException(ShopWebApiResultCodeEnum.I_UPLOAD_FILE_FAILED);
        }
        FileUtil.upload(files, this.initializeContext.getServerContext().getUploadDir().getAbsolutePath());
        List<File> processFiles = FileUtil.listFiles(this.initializeContext.getServerContext().getUploadDir());
        ArrayList<String> filesName = new ArrayList<String>();
        for (MultipartFile file : files) {
            String name = file.getOriginalFilename();
            assert (name != null);
            name = name.substring(name.lastIndexOf(92) + 1);
            filesName.add(name);
        }
        if (processFiles == null) {
            for (String name : filesName) {
                map.put(name, "FAILED");
            }
            return map;
        }
        List processFileName = processFiles.stream().map(File::getName).collect(Collectors.toList());
        if (files.size() != processFiles.size()) {
            for (String name : filesName) {
                if (processFileName.contains(name)) {
                    map.put(name, "SUCCESS");
                    continue;
                }
                map.put(name, "FAILED");
            }
        } else {
            for (File file : processFiles) {
                File backFile = new File(this.initializeContext.getServerContext().getBackupDir() + File.separator + file.getName());
                FileUtil.backupFile(file, backFile);
                file.delete();
            }
            for (String name : filesName) {
                map.put(name, "SUCCESS");
            }
        }
        return map;
    }

    @GetMapping(value={"/name/check"})
    public Object checkFileName(@RequestParam(value="filePattern") String filePattern, @RequestParam(value="fileName") String fileName) {
        if (filePattern == null || fileName == null) {
            throw new ApiException(ShopWebApiResultCodeEnum.FAILED);
        }
        Pattern pattern = Pattern.compile(filePattern);
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            return ShopWebApiResultCodeEnum.SUCCEED;
        }
        throw new ApiException(ShopWebApiResultCodeEnum.FAILED);
    }
}

