/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.enums;

public enum FileTypeEnum {
    CSV("CSV", 1),
    XLS("XLS", 2),
    XLSX("XLSX", 3),
    TXT("TXT", 4),
    FIXED("FIXEDLENGTH", 5),
    XML("XML", 6);

    private String type;
    private int code;

    private FileTypeEnum(String type, int code) {
        this.type = type;
        this.code = code;
    }

    public String getType() {
        return this.type;
    }

    public int getCode() {
        return this.code;
    }

    public static FileTypeEnum fromType(String type) {
        for (FileTypeEnum fileTypeEnum : FileTypeEnum.values()) {
            if (!type.endsWith(fileTypeEnum.type)) continue;
            return fileTypeEnum;
        }
        return null;
    }

    public boolean matchesFileName(String fileName) {
        if (fileName == null) {
            return false;
        }
        if (this.type.equals("FIXEDLENGTH")) {
            return false;
        }
        return fileName.toUpperCase().endsWith(this.type);
    }
}

