/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.exception;

import com.hanshow.intsmart.api.ShopWebApiResponse;
import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;

public class ApiException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final ShopWebApiResultCodeEnum resultCode;
    private Object data;

    public ApiException(Throwable cause, ShopWebApiResultCodeEnum resultCode, String fmt, Object ... args) {
        super(String.format(fmt, args), cause);
        this.resultCode = resultCode;
    }

    public ApiException(ShopWebApiResultCodeEnum resultCode) {
        super(resultCode.getMessage(), null);
        this.resultCode = resultCode;
    }

    public ApiException(ShopWebApiResultCodeEnum resultCode, Object data) {
        super(resultCode.getMessage(), null);
        this.resultCode = resultCode;
        this.data = data;
    }

    public ApiException(ShopWebApiResultCodeEnum resultCode, String fmt, Object ... args) {
        this(null, resultCode, fmt, args);
    }

    public ShopWebApiResponse getResponse() {
        ShopWebApiResponse response = new ShopWebApiResponse(this.resultCode, this.data);
        response.setMessage(this.getMessage());
        return response;
    }
}

