/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.exception;

import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseEntity<Map<String, Object>> noHandleFoundException(NoHandlerFoundException e) {
        String message = e.getMessage();
        log.error(message, e);
        HashMap<String, Object> errorBody = new HashMap<String, Object>();
        errorBody.put("errorCode", ShopWebApiResultCodeEnum.cdi_api_does_not_exist.getCode());
        errorBody.put("message", ShopWebApiResultCodeEnum.cdi_api_does_not_exist.getMessage());
        return ResponseEntity.status(HttpStatus.NOT_FOUND).body(errorBody);
    }

    @ExceptionHandler(value={OutOfMemoryError.class})
    public ResponseEntity<Map<String, Object>> oomException(OutOfMemoryError e) {
        String message = e.getMessage();
        log.error(message, e);
        HashMap<String, Object> errorBody = new HashMap<String, Object>();
        errorBody.put("errorCode", ShopWebApiResultCodeEnum.FAILED.getCode());
        errorBody.put("message", ShopWebApiResultCodeEnum.FAILED.getMessage());
        return ResponseEntity.status(HttpStatus.METHOD_NOT_ALLOWED).body(errorBody);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (e instanceof OutOfMemoryError) {
            log.error("global catch outOfMemory error, {}", (Object)e.getMessage(), (Object)e);
        } else {
            log.warn("global catch other error, {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void register() {
        Thread.setDefaultUncaughtExceptionHandler(new GlobalExceptionHandler());
    }
}

