/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.handler;

import com.hanshow.cdi.common.GetStoreCodeTypeEnum;
import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.cdi.ftp.FtpClientWrap;
import com.hanshow.cdi.sftp.SftpClientWrap;
import com.hanshow.cdi.util.AESUtils;
import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.service.ProcessFileService;
import com.hanshow.intsmart.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class IntegrationHandler {
    private static final Logger log = LogManager.getLogger(IntegrationHandler.class);

    public abstract List<File> process(String var1);

    public abstract List<File> process();

    public List<File> downloadFiles() {
        return null;
    }

    public List<File> downloadFiles(InitializeContext initializeContext, String storeCode, String taskName) {
        FtpClientWrap ftpClient = new FtpClientWrap();
        ArrayList<File> fileList = new ArrayList<File>();
        String ftpClientHost = initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFtpClientHost();
        int ftpClientPort = initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFtpClientPort();
        String ftpClientUsername = initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFtpClientUsername();
        String ftpClientPassword = AESUtils.decrypt(initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFtpClientPassword());
        String ftpClientPath = initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFtpClientPath() + (String)(storeCode == null ? "" : "/" + storeCode);
        String prefix = StringUtils.isNotBlank(initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFilePrefix()) ? initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFilePrefix() : "";
        String extension = initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFileExtension();
        if ("".equals(ftpClientHost) || ftpClientHost == null) {
            log.error("ftpClientHost is null");
            return new ArrayList<File>();
        }
        try {
            ftpClient.connectServer(ftpClientHost, ftpClientPort, ftpClientUsername, ftpClientPassword, initializeContext.getServerContext().getCdiSystem().getCharset());
            log.info("create ftpClient, the host is : [{}], the port is : [{}]", (Object)ftpClientHost, (Object)ftpClientPort);
            ftpClient.setFileTypeToBinary();
            ftpClient.changeWorkingDirectory(ftpClientPath);
            List<String> fileNameList = ftpClient.getFileList(ftpClientPath);
            if (!fileNameList.isEmpty()) {
                fileNameList.forEach(fileName -> {
                    if (fileName.toUpperCase().startsWith(prefix.toUpperCase()) && fileName.toUpperCase().endsWith(extension.toUpperCase())) {
                        File file = new File(initializeContext.getServerContext().getTaskLocalDirMap().get(taskName) + (String)(storeCode == null ? "" : "/" + storeCode), (String)fileName);
                        try {
                            boolean result = ftpClient.downloadFile((String)fileName, file.getAbsolutePath());
                            if (result) {
                                fileList.add(file);
                                if (ftpClient.deleteFile((String)fileName)) {
                                    log.info("Store {} delele ftp file {} succeed", (Object)storeCode, fileName);
                                }
                            }
                        }
                        catch (IOException e) {
                            log.error("Downloading files from target FTP has failed! " + e);
                        }
                    }
                });
            }
            ftpClient.closeServer();
        }
        catch (SocketException e) {
            log.error("Creating the target FTP connection failed! " + e, (Throwable)e);
        }
        catch (IOException e) {
            log.error("Login target FTP has failed! " + e, (Throwable)e);
        }
        return fileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> downloadSftpFiles(InitializeContext initializeContext, String storeCode, String taskName) {
        ArrayList<File> fileList = new ArrayList<File>();
        String sftpClientHost = initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getSftpClientHost();
        int sftpClientPort = initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getSftpClientPort();
        String sftpClientUsername = initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getSftpClientUsername();
        String sftpClientPassword = AESUtils.decrypt(initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getSftpClientPassword());
        String prefix = StringUtils.isNotBlank(initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFilePrefix()) ? initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFilePrefix() : "";
        String extension = initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFileExtension();
        if ("".equals(sftpClientHost) || sftpClientHost == null) {
            log.error("ftpClientHost is null");
            return new ArrayList<File>();
        }
        SftpClientWrap sftpClient = new SftpClientWrap(sftpClientHost, sftpClientPort, sftpClientUsername, sftpClientPassword);
        try {
            sftpClient.connect();
            log.info("create sftpClient, the host is : [{}], the port is : [{}]", (Object)sftpClientHost, (Object)sftpClientPort);
            String remotePath = initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getSftpClientPath() + (String)(storeCode == null ? "" : storeCode + "/");
            String localPath = initializeContext.getServerContext().getTaskLocalDirMap().get(taskName) + (String)(storeCode == null ? "" : File.separator + storeCode);
            List<String> fileNameList = sftpClient.batchDownLoadFile(remotePath, localPath, prefix, extension, true);
            if (!fileNameList.isEmpty()) {
                fileNameList.forEach(fileName -> {
                    File file = new File(localPath + File.separator + fileName);
                    fileList.add(file);
                });
            }
        }
        catch (Exception e) {
            log.error("create sftpClient failed, the host is : [{}], the port is : [{}]", (Object)sftpClientHost, (Object)sftpClientPort);
        }
        finally {
            sftpClient.disconnect();
        }
        return fileList;
    }

    public String getStoreCodeByPattern(String fileName, String format) {
        String p = "(?<=hanshow_).*(?=\\.csv)";
        Pattern pattern = Pattern.compile(format);
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public void processFile(ProcessFileService processFileService, File file, GenericCdiServerContext serverContext, String taskName) {
        this.judgeFileTypeAndFormatFile(processFileService, file, null, taskName, serverContext.getTaskMap().get(taskName).getDatasource().getFileExtension(), GetStoreCodeTypeEnum.FromFile);
        this.backupFile(file, serverContext, taskName);
        file.delete();
    }

    public void processFileByDir(ProcessFileService processFileService, File file, GenericCdiServerContext serverContext, String storeCode, String taskName) {
        this.judgeFileTypeAndFormatFile(processFileService, file, storeCode, taskName, serverContext.getTaskMap().get(taskName).getDatasource().getFileExtension(), GetStoreCodeTypeEnum.ByDir);
        this.backupFile(file, serverContext, taskName);
        file.delete();
    }

    public void processFileByFileName(ProcessFileService processFileService, File file, GenericCdiServerContext serverContext, String taskName) {
        String storeCode = this.getStoreCodeByPattern(file.getName(), serverContext.getTaskMap().get(taskName).getDatasource().getFilePattern());
        if (storeCode == null || !serverContext.getTaskServerTransformStoreCodeMap().get(taskName).containsKey(storeCode)) {
            log.warn("[ {} ] This file storeCode is not configured Task {} : storeCode {}", (Object)file.getName(), (Object)taskName, (Object)storeCode);
            return;
        }
        this.judgeFileTypeAndFormatFile(processFileService, file, storeCode, taskName, serverContext.getTaskMap().get(taskName).getDatasource().getFileExtension(), GetStoreCodeTypeEnum.ByFileName);
        this.backupFile(file, serverContext, taskName);
        file.delete();
    }

    public void processFileToAllStores(ProcessFileService processFileService, File file, GenericCdiServerContext serverContext, String taskName) {
        this.judgeFileTypeAndFormatFile(processFileService, file, null, taskName, serverContext.getTaskMap().get(taskName).getDatasource().getFileExtension(), GetStoreCodeTypeEnum.ToAllStores);
        this.backupFile(file, serverContext, taskName);
        file.delete();
    }

    private void judgeFileTypeAndFormatFile(ProcessFileService processFileService, File file, String storeCode, String taskName, String selectFileType, GetStoreCodeTypeEnum storeType) {
        processFileService.formatFile(file, selectFileType, storeCode, taskName, storeType);
    }

    private void backupFile(File file, GenericCdiServerContext serverContext, String taskName) {
        File backFile = new File(serverContext.getBackupDir() + File.separator + taskName + File.separator + System.currentTimeMillis() + file.getName());
        log.info("[Task {}] backup [{}] to [{}]", (Object)taskName, (Object)file.getAbsolutePath(), (Object)backFile.getAbsolutePath());
        FileUtil.backupFile(file, backFile);
    }
}

