/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.handler;

import com.hanshow.cdi.common.GetStoreCodeTypeEnum;
import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.intsmart.centre.InitializeContext;
import com.hanshow.intsmart.enums.FileTypeEnum;
import com.hanshow.intsmart.model.entity.CustomerUploadFile;
import com.hanshow.intsmart.model.entity.Duration;
import com.hanshow.intsmart.service.ProcessFileService;
import com.hanshow.intsmart.service.impl.ProcessFileServiceImpl;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerHandler {
    private static final Logger log = LogManager.getLogger(ServerHandler.class);
    private InitializeContext initializeContext;
    private ProcessFileService processFileService;
    private GenericCdiServerContext serverContext;
    private Lock lock;
    private Processor[] processors;
    private int workers;
    Map<String, LinkedBlockingDeque<CustomerUploadFile>> taskQueue = new HashMap<String, LinkedBlockingDeque<CustomerUploadFile>>();
    Map<Integer, LinkedBlockingDeque<String>> processerQueue = new HashMap<Integer, LinkedBlockingDeque<String>>();

    public ServerHandler(int threadsNum, InitializeContext initializeContext) {
        int i;
        log.info("serverHandler threadsNum :" + threadsNum);
        this.initializeContext = initializeContext;
        this.serverContext = this.initializeContext.getServerContext();
        this.workers = threadsNum;
        this.processFileService = new ProcessFileServiceImpl(initializeContext);
        this.lock = new ReentrantLock();
        for (i = 0; i < threadsNum; ++i) {
            this.processerQueue.put(i, new LinkedBlockingDeque());
        }
        this.processors = new Processor[threadsNum];
        for (i = 0; i < threadsNum; ++i) {
            this.processors[i] = new Processor(i);
        }
    }

    public void submit(CustomerUploadFile uploadedFile) {
        String storeCode = uploadedFile.getStoreCode();
        String taskName = uploadedFile.getTaskName();
        String queueID = taskName + storeCode;
        if (this.taskQueue.containsKey(queueID)) {
            this.taskQueue.get(queueID).add(uploadedFile);
        } else {
            LinkedBlockingDeque<CustomerUploadFile> fileQueue = new LinkedBlockingDeque<CustomerUploadFile>();
            fileQueue.add(uploadedFile);
            this.taskQueue.put(queueID, fileQueue);
        }
        Integer workerNum = Math.abs(queueID.hashCode() % this.workers);
        if (!this.checkKeyFromQueue(this.processerQueue.get(workerNum), queueID)) {
            this.processerQueue.get(workerNum).add(queueID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkKeyFromQueue(LinkedBlockingDeque<String> queue, String key) {
        this.lock.lock();
        try {
            boolean bl = queue.contains(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getStoreCodeByPattern(String fileName, String format) {
        Pattern pattern = Pattern.compile(format);
        Matcher matcher = pattern.matcher(fileName);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private class Processor
    implements Runnable {
        private Thread thread;

        public Processor(int num) {
            this.thread = new Thread((Runnable)this, "customerUploadedFileProcessor-" + num);
            this.thread.start();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            workerNum = Thread.currentThread().getName().split("-")[1] == null ? 0 : Integer.parseInt(Thread.currentThread().getName().split("-")[1]);
            while (true) {
                try {
                    block3: while (true) {
                        sum = 0;
                        queueID = ServerHandler.this.processerQueue.get(workerNum).take();
                        if (ServerHandler.this.taskQueue.get(queueID).size() <= 0) continue;
                        while (true) {
                            if (sum >= ServerHandler.this.serverContext.getCdiSystem().getSenderWorkerNum()) {
                                ServerHandler.log.info(String.format("worker %s take file from %s greater than or equal to %s", new Object[]{workerNum, queueID, ServerHandler.this.serverContext.getCdiSystem().getSenderWorkerNum()}));
                                if (ServerHandler.this.checkKeyFromQueue(ServerHandler.this.processerQueue.get(workerNum), queueID)) continue block3;
                                ServerHandler.this.processerQueue.get(workerNum).add(queueID);
                                ServerHandler.log.info(String.format("worker %s add a task: %s", new Object[]{workerNum, queueID}));
                                continue block3;
                            }
                            uploadFile = ServerHandler.this.taskQueue.get(queueID).poll(2000L, TimeUnit.MILLISECONDS);
                            if (uploadFile != null) ** break;
                            continue block3;
                            this.process(uploadFile);
                            ++sum;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    ServerHandler.log.error("Process uploaded file error.", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void process(CustomerUploadFile uploadFile) {
            log.info(String.format("================================%s FILE %s PROCESSING=====================================", uploadFile.getTaskName(), uploadFile.getAbsoluteFile().getName()));
            Duration duration = new Duration();
            String taskName = uploadFile.getTaskName();
            if (uploadFile.getAbsoluteFile().getName().toUpperCase().startsWith(StringUtils.isNotBlank(ServerHandler.this.initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFilePrefix()) ? ServerHandler.this.initializeContext.getServerContext().getTaskMap().get(taskName).getDatasource().getFilePrefix().toUpperCase() : "") && (uploadFile.getAbsoluteFile().getName().toUpperCase().endsWith(ServerHandler.this.serverContext.getTaskMap().get(taskName).getDatasource().getFileExtension().toUpperCase()) || ServerHandler.this.serverContext.getTaskMap().get(taskName).getDatasource().getFileExtension().equals(FileTypeEnum.FIXED.getType()))) {
                File file = uploadFile.getAbsoluteFile();
                if (ServerHandler.this.serverContext.getTaskMap().get(taskName).getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.ToAllStores.getType()) {
                    ServerHandler.this.serverContext.getTaskServerTransformStoreCodeMap().get(taskName).forEach((k, v) -> {
                        if (ServerHandler.this.serverContext.getTaskMap().get(taskName).getDatasource().getFileExtension().equals(FileTypeEnum.FIXED.getType())) {
                            ServerHandler.this.processFileService.formatFile(file, FileTypeEnum.FIXED.getType(), (String)k, taskName, GetStoreCodeTypeEnum.ToAllStores);
                        } else if (ServerHandler.this.serverContext.getTaskMap().get(taskName).getDatasource().getFileExtension().equals(FileTypeEnum.XML.getType())) {
                            ServerHandler.this.processFileService.formatFile(file, FileTypeEnum.XML.getType(), (String)k, taskName, GetStoreCodeTypeEnum.ToAllStores);
                        } else if (file.getName().toUpperCase().endsWith(FileTypeEnum.XLS.getType())) {
                            ServerHandler.this.processFileService.formatFile(file, FileTypeEnum.XLS.getType(), (String)k, taskName, GetStoreCodeTypeEnum.ToAllStores);
                        } else if (file.getName().toUpperCase().endsWith(FileTypeEnum.XLSX.getType())) {
                            ServerHandler.this.processFileService.formatFile(file, FileTypeEnum.XLSX.getType(), (String)k, taskName, GetStoreCodeTypeEnum.ToAllStores);
                        } else {
                            ServerHandler.this.processFileService.formatFile(file, FileTypeEnum.TXT.getType(), (String)k, taskName, GetStoreCodeTypeEnum.ToAllStores);
                        }
                    });
                } else {
                    GetStoreCodeTypeEnum storeCodeType;
                    GetStoreCodeTypeEnum getStoreCodeTypeEnum = storeCodeType = ServerHandler.this.serverContext.getTaskMap().get(taskName).getDatasource().getFileGetType().intValue() == GetStoreCodeTypeEnum.FromFile.getType() ? GetStoreCodeTypeEnum.FromFile : GetStoreCodeTypeEnum.ByFileName;
                    if (ServerHandler.this.serverContext.getTaskMap().get(taskName).getDatasource().getFileExtension().equals(FileTypeEnum.FIXED.getType())) {
                        ServerHandler.this.processFileService.formatFile(file, FileTypeEnum.FIXED.getType(), uploadFile.getStoreCode(), taskName, storeCodeType);
                    } else if (ServerHandler.this.serverContext.getTaskMap().get(taskName).getDatasource().getFileExtension().equals(FileTypeEnum.XML.getType())) {
                        ServerHandler.this.processFileService.formatFile(file, FileTypeEnum.XML.getType(), uploadFile.getStoreCode(), taskName, storeCodeType);
                    } else if (file.getName().toUpperCase().endsWith(FileTypeEnum.XLS.getType())) {
                        ServerHandler.this.processFileService.formatFile(file, FileTypeEnum.XLS.getType(), uploadFile.getStoreCode(), taskName, storeCodeType);
                    } else if (file.getName().toUpperCase().endsWith(FileTypeEnum.XLSX.getType())) {
                        ServerHandler.this.processFileService.formatFile(file, FileTypeEnum.XLSX.getType(), uploadFile.getStoreCode(), taskName, storeCodeType);
                    } else {
                        ServerHandler.this.processFileService.formatFile(file, FileTypeEnum.TXT.getType(), uploadFile.getStoreCode(), taskName, storeCodeType);
                    }
                }
                log.info("Task {} process file {} complete time consuming {}ms", (Object)uploadFile.getTaskName(), (Object)uploadFile.getAbsoluteFile().getName(), (Object)duration.getTotal());
                file.delete();
            } else {
                log.info("Task {} process file {} type invalid ", (Object)uploadFile.getTaskName(), (Object)uploadFile.getAbsoluteFile().getName());
            }
            uploadFile.getAbsoluteFile().delete();
        }
    }
}

