/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.job;

import com.hanshow.intsmart.centre.InitializeContext;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerJob
implements Job {
    private static final Logger log = LogManager.getLogger(DataCleanerJob.class);
    @Autowired
    private InitializeContext initializeContext;
    private long dataKeepingMillis;
    private long logKeepingMillis;
    private long backupKeepingMillis;
    private Map<File, Long> dirs;

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.dataKeepingMillis = (long)(this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getDataFileKeepingDays() * 24 * 60 * 60) * 1000L;
        this.logKeepingMillis = (long)(this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getLogFileKeepingDays() * 24 * 60 * 60) * 1000L;
        this.backupKeepingMillis = (long)(this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getBackupFileKeepingDays() * 24 * 60 * 60) * 1000L;
        this.dirs = new LinkedHashMap<File, Long>();
        this.dirs.put(new File(this.initializeContext.getServerContext().getRootDir(), "ftp"), this.dataKeepingMillis);
        this.dirs.put(new File(this.initializeContext.getServerContext().getRootDir(), "sftp"), this.dataKeepingMillis);
        this.dirs.put(new File(this.initializeContext.getServerContext().getRootDir(), "msg"), this.dataKeepingMillis);
        this.dirs.put(new File(this.initializeContext.getServerContext().getRootDir(), "msg_file"), this.dataKeepingMillis);
        this.dirs.put(this.initializeContext.getServerContext().getTemporaryDir(), this.dataKeepingMillis);
        this.dirs.put(this.initializeContext.getServerContext().getLogDir(), this.logKeepingMillis);
        this.dirs.put(this.initializeContext.getServerContext().getBackupDir(), this.backupKeepingMillis);
        log.info("================================CLEANING=====================================");
        log.info("Data file keeping days: " + this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getDataFileKeepingDays());
        log.info("Log file keeping days: " + this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getLogFileKeepingDays());
        log.info("Backup file keeping days: " + this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getBackupFileKeepingDays());
        this.dirs.forEach((file, mills) -> log.info("Clean directory: " + file.getAbsolutePath()));
        this.dirs.forEach(this::cleanDir);
        log.info("================================CLEANED FINISHED=====================================");
    }

    private void cleanDir(File dir, long mills) {
        File[] files;
        if (dir == null) {
            return;
        }
        if (!dir.exists()) {
            return;
        }
        for (File f : files = dir.listFiles()) {
            if (f.isDirectory()) {
                this.cleanDir(f, mills);
                continue;
            }
            if (System.currentTimeMillis() - f.lastModified() < mills) continue;
            if (!f.delete()) {
                log.error("Clear history file failed: " + f.getAbsolutePath());
                continue;
            }
            log.info("Clear history file: " + f.getAbsolutePath());
        }
    }
}

