/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.job.jobListener;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientIntegrationJobListener
implements JobListener {
    private static final Logger log = LoggerFactory.getLogger(ClientIntegrationJobListener.class);

    @Override
    public String getName() {
        return "ClientIntegrationJobListener";
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
        log.info("Job [{}] is about to be executed", (Object)jobExecutionContext.getJobDetail().getKey());
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {
        log.info("Job [{}] execution was vetoed", (Object)jobExecutionContext.getJobDetail().getKey());
    }

    @Override
    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobException) {
        log.info("Job [{}] has been executed", (Object)jobExecutionContext.getJobDetail().getKey());
        if (jobException != null) {
            log.error("Job [{}] encountered an error: {}", (Object)jobExecutionContext.getJobDetail().getKey(), (Object)jobException.getMessage());
        }
    }
}

