/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.listener;

import com.hanshow.cdi.common.GetStoreCodeTypeEnum;
import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.cdi.core.PathHelper;
import com.hanshow.cdi.ftp.FtpEventListener;
import com.hanshow.cdi.util.Utils;
import com.hanshow.intsmart.enums.ServerTypeEnum;
import com.hanshow.intsmart.handler.ServerHandler;
import com.hanshow.intsmart.model.entity.CustomerUploadFile;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.FtpletResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUploadedListener
extends FtpEventListener {
    private static final Logger log = LogManager.getLogger(FileUploadedListener.class);
    private ServerHandler processor;
    private GenericCdiServerContext serverContext;
    private static SimpleDateFormat bakDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    public FileUploadedListener(GenericCdiServerContext serverContext, ServerHandler processor) {
        this.serverContext = serverContext;
        this.processor = processor;
    }

    @Override
    public FtpletResult onUploadEnd(FtpSession session, FtpRequest request) {
        if (!"STOR".equalsIgnoreCase(request.getCommand())) {
            log.warn("-- On Upload End received non-STOR event.");
            return null;
        }
        String userName = session.getUser().getName();
        try {
            String storeCode;
            String workingDir = session.getFileSystemView().getWorkingDirectory().getAbsolutePath();
            String fileName = request.getArgument();
            String taskName = userName;
            Integer fileType = this.serverContext.getTaskMap().get(taskName).getDatasource().getFileGetType();
            if (fileType.intValue() == GetStoreCodeTypeEnum.ByFileName.getType()) {
                storeCode = this.processor.getStoreCodeByPattern(fileName, this.serverContext.getTaskMap().get(taskName).getDatasource().getFilePattern());
                if (!this.serverContext.getTaskServerTransformStoreCodeMap().get(taskName).containsKey(storeCode)) {
                    log.info("Store {} is not configured", (Object)storeCode);
                    File absoluteFile = PathHelper.getUserUploadedFile(this.serverContext.getRootDir(), userName, workingDir, fileName);
                    absoluteFile.delete();
                    return FtpletResult.DEFAULT;
                }
            } else {
                storeCode = null;
            }
            CustomerUploadFile customerUploadFile = new CustomerUploadFile(userName, workingDir, fileName, this.serverContext.getRootDir(), taskName, storeCode, ServerTypeEnum.FTP);
            File target = new File(this.serverContext.getBackupDir() + File.separator + taskName + File.separator + bakDateFormat.format(new Date()) + "-" + fileName);
            Utils.copyFile(customerUploadFile.getAbsoluteFile(), target);
            log.info(String.format("User %s received task %s uploaded file: " + customerUploadFile.getAbsoluteFile().getAbsolutePath(), userName, taskName));
            this.processor.submit(customerUploadFile);
        }
        catch (Exception e) {
            log.error(String.format("process user %s uploaded file error.", userName), (Throwable)e);
        }
        return FtpletResult.DEFAULT;
    }
}

