/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.model.database;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.hanshow.intsmart.configuration.DbProperties;
import com.hanshow.intsmart.enums.DbTypeEnum;
import com.hanshow.intsmart.util.SpringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final Logger log = LogManager.getLogger(DynamicDataSource.class);
    private static final ThreadLocal<String> dataSourceKey = ThreadLocal.withInitial(() -> "defaultDataSource");
    public static Map<Object, Object> dataSourcesMap = new ConcurrentHashMap<Object, Object>(10);

    public DynamicDataSource(String type, String url, String username, String password, DbProperties dbProperties, boolean cdiSwitch) {
        if (cdiSwitch) {
            DruidDataSource defaultDataSource = DruidDataSourceBuilder.create().build();
            defaultDataSource.setUrl(url);
            defaultDataSource.setUsername(username);
            defaultDataSource.setPassword(password);
            DynamicDataSource.setProperties(defaultDataSource, type, dbProperties);
            dataSourcesMap.put("defaultDataSource", defaultDataSource);
        }
    }

    @Override
    protected Object determineCurrentLookupKey() {
        return dataSourceKey.get();
    }

    public static void setDataSource(String dataSource) {
        log.info("Datasource key is:{}", (Object)dataSourcesMap.keySet());
        dataSourceKey.set(dataSource);
    }

    public static String getDataSource() {
        return dataSourceKey.get();
    }

    public static void clear() {
        dataSourceKey.remove();
    }

    public static void setProperties(DruidDataSource dataSource, String type, DbProperties dbProperties) {
        try {
            dataSource.setMaxActive(20);
            dataSource.setInitialSize(1);
            dataSource.setMaxWait(60000L);
            dataSource.setMinIdle(5);
            dataSource.setTimeBetweenEvictionRunsMillis(20000L);
            dataSource.setMinEvictableIdleTimeMillis(300000L);
            dataSource.setTestWhileIdle(true);
            dataSource.setTestOnBorrow(false);
            dataSource.setTestOnReturn(false);
            dataSource.setPoolPreparedStatements(true);
            dataSource.setMaxOpenPreparedStatements(20);
            if (DbTypeEnum.MYSQL.getType().equalsIgnoreCase(type)) {
                dataSource.setDbType(DbTypeEnum.MYSQL.getType());
                dataSource.setDriverClassName(dbProperties.getMysqlDriver());
                dataSource.setValidationQuery("select 1");
            } else if (DbTypeEnum.SQLSERVER.getType().equalsIgnoreCase(type)) {
                dataSource.setDbType(DbTypeEnum.SQLSERVER.getType());
                dataSource.setDriverClassName(dbProperties.getSqlServerDriver());
                dataSource.setValidationQuery("select 1");
            } else if (DbTypeEnum.ORACLE.getType().equalsIgnoreCase(type)) {
                dataSource.setDbType(DbTypeEnum.ORACLE.getType());
                dataSource.setDriverClassName(dbProperties.getOracleDriver());
                dataSource.setValidationQuery("select 1 from dual");
            } else if (DbTypeEnum.POSTGRESQL.getType().equalsIgnoreCase(type)) {
                dataSource.setDbType(DbTypeEnum.POSTGRESQL.getType());
                dataSource.setDriverClassName(dbProperties.getPostgreSqlDriver());
                dataSource.setValidationQuery("select version()");
            } else if (DbTypeEnum.SYBASE.getType().equalsIgnoreCase(type)) {
                dataSource.setDbType(DbTypeEnum.SYBASE.getType());
                dataSource.setDriverClassName(dbProperties.getSybaseDriver());
                dataSource.setValidationQuery("select 1");
            } else if (DbTypeEnum.SQLITE.getType().equals(type)) {
                dataSource.setDbType(DbTypeEnum.SQLITE.getType());
                dataSource.setDriverClassName(dbProperties.getSqlLiteDriver());
                dataSource.setValidationQuery("select 1");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            dataSource = null;
        }
    }

    static {
        dataSourcesMap.put("defaultDataSource", SpringUtils.getBean("defaultDataSource"));
    }
}

