/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.pgpFileProcess;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.springframework.core.io.ClassPathResource;

public class pgpDecryption {
    public static File decryptFile(String encryptedFilePath, String privateKeyFileName, String outputFilePath, char[] password) throws Exception {
        FileInputStream encryptedData = new FileInputStream(encryptedFilePath);
        FileInputStream keyInput = new FileInputStream(new ClassPathResource(privateKeyFileName).getFile());
        File outputFile = new File(outputFilePath);
        try (FileOutputStream decryptedOut = new FileOutputStream(outputFile);){
            pgpDecryption.decrypt(encryptedData, keyInput, password, decryptedOut);
        }
        ((InputStream)encryptedData).close();
        ((InputStream)keyInput).close();
        return outputFile;
    }

    public static void decrypt(InputStream encryptedData, InputStream keyIn, char[] passPhrase, OutputStream decryptedOut) throws Exception {
        PGPEncryptedData encryptedData2;
        PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(encryptedData = PGPUtil.getDecoderStream(encryptedData), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Object pgpObject = pgpObjectFactory.nextObject();
        PGPEncryptedDataList encryptedDataList = pgpObject instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)pgpObject : (PGPEncryptedDataList)pgpObjectFactory.nextObject();
        Iterator<PGPEncryptedData> it = encryptedDataList.getEncryptedDataObjects();
        PGPPrivateKey privateKey = null;
        PGPPublicKeyEncryptedData publicKeyEncryptedData = null;
        while (it.hasNext() && (!((encryptedData2 = it.next()) instanceof PGPPublicKeyEncryptedData) || (privateKey = pgpDecryption.findPrivateKey(keyIn, (publicKeyEncryptedData = (PGPPublicKeyEncryptedData)encryptedData2).getKeyID(), passPhrase)) == null)) {
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("Secret key for message not found.");
        }
        InputStream decryptedData = publicKeyEncryptedData.getDataStream(new BcPublicKeyDataDecryptorFactory(privateKey));
        PGPObjectFactory plainFactory = new PGPObjectFactory(decryptedData, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPCompressedData compressedData = (PGPCompressedData)plainFactory.nextObject();
        BufferedInputStream compressedStream = new BufferedInputStream(compressedData.getDataStream());
        PGPObjectFactory pgpFactory = new PGPObjectFactory(compressedStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Object message = pgpFactory.nextObject();
        if (message instanceof PGPLiteralData) {
            int ch;
            PGPLiteralData literalData = (PGPLiteralData)message;
            InputStream literalStream = literalData.getInputStream();
            while ((ch = literalStream.read()) >= 0) {
                decryptedOut.write(ch);
            }
        }
    }

    private static PGPPrivateKey findPrivateKey(InputStream keyIn, long keyID, char[] passPhrase) throws Exception {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(keyIn), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPSecretKey secretKey = pgpSec.getSecretKey(keyID);
        if (secretKey == null) {
            return null;
        }
        PBESecretKeyDecryptor decryptor = new BcPBESecretKeyDecryptorBuilder(new BcPGPDigestCalculatorProvider()).build(passPhrase);
        return secretKey.extractPrivateKey(decryptor);
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

