/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.scheduler;

import com.hanshow.intsmart.scheduler.JobExcuteScheduler;
import com.hanshow.intsmart.scheduler.JobFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
public class JobExcuteSchedulerListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LogManager.getLogger(JobExcuteSchedulerListener.class);
    @Autowired
    private JobExcuteScheduler jobExcuteScheduler;
    @Autowired
    private JobFactory jobFactory;

    @Override
    public void onApplicationEvent(ContextRefreshedEvent arg0) {
        try {
            this.jobExcuteScheduler.scheduleJobs();
        }
        catch (SchedulerException e) {
            log.error("Job schedule initialize with an error: " + e);
        }
    }

    @Bean
    public SchedulerFactoryBean schedulerFactoryBean() {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        schedulerFactoryBean.setOverwriteExistingJobs(true);
        schedulerFactoryBean.setJobFactory(this.jobFactory);
        return schedulerFactoryBean;
    }
}

