/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.service.impl;

import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.intsmart.configuration.DbProperties;
import com.hanshow.intsmart.service.DatabaseLinkService;
import com.hanshow.intsmart.util.DBUtil;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatabaseLinkServiceImpl
implements DatabaseLinkService {
    private static final Logger log = LogManager.getLogger(DatabaseLinkServiceImpl.class);
    @Autowired
    private DBUtil dbUtil;
    @Autowired
    DbProperties dbProperties;

    @Override
    public Map<String, String> getSysColumns(String driver, String url, String username, String password, String sql) {
        return this.getMap(driver, url, username, password, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getMap(String driver, String url, String username, String password, String sql) {
        HashMap<CallSite, String> map = new HashMap<CallSite, String>();
        HashMap<CallSite, String> map2 = new HashMap<CallSite, String>();
        HashMap<String, String> nameTypeMap = new HashMap<String, String>();
        HashMap<String, HashMap<CallSite, String>> map3 = new HashMap<String, HashMap<CallSite, String>>();
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = DBUtil.getConnect(driver, url, username, password);
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                map.put((CallSite)((Object)("" + i)), rsmd.getColumnName(i));
                map2.put((CallSite)((Object)("" + i)), rsmd.getColumnTypeName(i));
                nameTypeMap.put(rsmd.getColumnName(i), rsmd.getColumnTypeName(i));
            }
            map3.put("columnName", map);
            map3.put("columnType", map2);
        }
        catch (SQLException e) {
            try {
                log.error(e);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, stmt, rs);
                throw throwable;
            }
            DBUtil.close(conn, stmt, rs);
        }
        DBUtil.close(conn, stmt, rs);
        return nameTypeMap;
    }

    @Override
    public Map<String, String> getSysColumns(CdiProperties.Task taskForm) {
        String url = this.dbUtil.getUrl(taskForm);
        String userName = taskForm.getDatasource().getDatabaseUsername();
        String passWord = taskForm.getDatasource().getDatabasePassword();
        String sql = taskForm.getDatasource().getDatabaseSql();
        String driver = DBUtil.getDriver(taskForm.getDatasource().getDatabaseType(), this.dbProperties);
        log.info("driver : {}", (Object)driver);
        log.info("url : {}", (Object)url);
        log.info("userName : {}", (Object)userName);
        log.info("passWord : {}", (Object)passWord);
        return this.getMap(driver, url, userName, passWord, sql);
    }
}

