/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.service.impl;

import com.hanshow.cdi.core.ServerMode;
import com.hanshow.intsmart.model.entity.Field;
import com.hanshow.intsmart.service.FieldService;
import com.hanshow.intsmart.util.FileUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class FieldServiceImpl
implements FieldService {
    private static final Logger log = LogManager.getLogger(FieldServiceImpl.class);

    @Override
    public List<Field> getAllField(String serverMode) {
        InputStream inputStream = null;
        if (serverMode.equals(ServerMode.PRISMART.getName())) {
            inputStream = this.getClass().getResourceAsStream("/config/prismart-1.0.0-rc1.properties");
        } else if (serverMode.equals(ServerMode.SHOPWEB.getName())) {
            inputStream = this.getClass().getResourceAsStream("/config/prismart-1.0.0-rc1.properties");
        } else if (serverMode.equals(ServerMode.PRISMART220RC6.getName())) {
            inputStream = this.getClass().getResourceAsStream("/config/prismart-2.2.0-rc6.properties");
        }
        List<String> lines = FileUtil.readFile(inputStream, "UTF-8");
        ArrayList<Field> result = new ArrayList<Field>();
        for (String s : lines) {
            if (s == null || "".equals(s) || s.contains("#")) continue;
            String key = s.split("=")[0];
            String value = s.split("=")[1];
            Field mf = new Field();
            mf.setName(key);
            String[] sm2 = value.split("\\|");
            mf.setType(sm2[0]);
            mf.setNameAndType(String.format("%s(%s)", key, value));
            mf.setRemark(sm2[1]);
            result.add(mf);
        }
        return result;
    }
}

