/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.service.impl;

import com.hanshow.intsmart.model.entity.XsdElement;
import com.hanshow.intsmart.service.XsdParseService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
public class XsdParseServiceImpl
implements XsdParseService {
    @Override
    public void traverseNodes(Node node, XsdElement currentElement) {
        block2: {
            block4: {
                String localName;
                block3: {
                    if (node.getNodeType() != 1) break block2;
                    localName = node.getLocalName();
                    if (!"element".equals(localName)) break block3;
                    Element element = (Element)node;
                    String name = element.getAttribute("name");
                    if (name == null || name.isEmpty()) break block2;
                    XsdElement newElement = new XsdElement(name, currentElement);
                    currentElement.addChild(newElement);
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.traverseNodes(children.item(i), newElement);
                    }
                    break block2;
                }
                if (!"attribute".equals(localName)) break block4;
                Element attribute = (Element)node;
                String name = attribute.getAttribute("name");
                if (name == null || name.isEmpty()) break block2;
                currentElement.addAttribute(name);
                break block2;
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.traverseNodes(children.item(i), currentElement);
            }
        }
    }

    @Override
    public Map<String, Object> convertToMap(XsdElement element) {
        HashMap<String, Object> elementMap = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> childrenMap = new HashMap<String, Map<String, Object>>();
        for (XsdElement child : element.children) {
            childrenMap.put(child.name, this.convertToMap(child));
        }
        if (!childrenMap.isEmpty()) {
            elementMap.put("children", childrenMap);
        }
        if (!element.attributes.isEmpty()) {
            elementMap.put("attributes", element.attributes);
        }
        return elementMap;
    }

    public void buildPaths(XsdElement element, String currentPath, List<String> paths) {
        if (element == null) {
            return;
        }
        Object path = currentPath.isEmpty() ? "/" + element.name : currentPath + "/" + element.name;
        if (StringUtils.isNotBlank((String)(path = ((String)path).replaceFirst("/schema", "")))) {
            paths.add((String)path);
        }
        if (element.attributes != null) {
            for (String attribute : element.attributes) {
                Object attributePath = (String)path + "/@" + attribute;
                if (!StringUtils.isNotBlank((String)(attributePath = ((String)attributePath).replaceFirst("schema", "")))) continue;
                paths.add((String)attributePath);
            }
        }
        for (XsdElement child : element.children) {
            this.buildPaths(child, (String)path, paths);
        }
    }

    @Override
    public List<String> convertToPaths(XsdElement rootElement) {
        ArrayList<String> paths = new ArrayList<String>();
        this.buildPaths(rootElement, "", paths);
        return paths;
    }
}

