/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.queue.CircularFifoQueue;

public class CookieUtil {
    private static volatile CircularFifoQueue<String> tokenSentQueue = new CircularFifoQueue(5);

    public static void set(HttpServletResponse response, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(maxAge);
        if (value != null) {
            tokenSentQueue.add(value);
        }
        response.addCookie(cookie);
    }

    public static Cookie get(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = CookieUtil.readCookieMap(request);
        return cookieMap.getOrDefault(name, null);
    }

    public static boolean getContain(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!tokenSentQueue.contains(cookie.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }
}

