/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.intsmart.configuration.DbProperties;
import com.hanshow.intsmart.enums.ConnectMethodEnum;
import com.hanshow.intsmart.enums.DbTypeEnum;
import com.hanshow.intsmart.enums.ShopWebApiResultCodeEnum;
import com.hanshow.intsmart.exception.ApiException;
import com.hanshow.intsmart.util.DbUrlUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DBUtil {
    private static final Logger log = LogManager.getLogger(DBUtil.class);
    @Autowired
    private DbUrlUtil dbUrlUtil;
    @Autowired
    private DbProperties dbProperties;

    public static Connection getConnect(String driver, String url, String userName, String passWord) {
        Connection conn = null;
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, userName, passWord);
        }
        catch (ClassNotFoundException | SQLException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ShopWebApiResultCodeEnum.FAILED, e.getMessage());
        }
        return conn;
    }

    public void structureTaskDatasource(CdiProperties.Task taskForm) {
        if (DbTypeEnum.MYSQL.getType().equals(taskForm.getDatasource().getDatabaseType())) {
            taskForm.getDatasource().setDatabaseDriver(this.dbProperties.getMysqlDriver());
            taskForm.getDatasource().setDatabaseUrl(String.format(this.dbUrlUtil.getMySqlUrl(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName()));
        } else if (DbTypeEnum.SYBASE.getType().equals(taskForm.getDatasource().getDatabaseType())) {
            taskForm.getDatasource().setDatabaseDriver(this.dbProperties.getSybaseDriver());
            taskForm.getDatasource().setDatabaseUrl(String.format(this.dbUrlUtil.getSybaseUrl(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName()));
        } else if (DbTypeEnum.POSTGRESQL.getType().equals(taskForm.getDatasource().getDatabaseType())) {
            taskForm.getDatasource().setDatabaseDriver(this.dbProperties.getPostgreSqlDriver());
            taskForm.getDatasource().setDatabaseUrl(String.format(this.dbUrlUtil.getPostgreSqlUrl(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName()));
        } else if (DbTypeEnum.SQLITE.getType().equals(taskForm.getDatasource().getDatabaseType())) {
            taskForm.getDatasource().setDatabaseDriver(this.dbProperties.getSqlLiteDriver());
            taskForm.getDatasource().setDatabaseUrl(String.format(this.dbUrlUtil.getSqlLiteUrl(), taskForm.getDatasource().getDatabaseFilePath()));
        } else {
            if (DbTypeEnum.SQLSERVER.getType().equalsIgnoreCase(taskForm.getDatasource().getDatabaseType()) && ConnectMethodEnum.PORT.getName().equalsIgnoreCase(taskForm.getDatasource().getConnectMethod())) {
                taskForm.getDatasource().setDatabaseDriver(this.dbProperties.getSqlServerDriver());
                taskForm.getDatasource().setDatabaseUrl(String.format(this.dbUrlUtil.getSqlServerUrl(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName()));
            }
            if (DbTypeEnum.SQLSERVER.getType().equalsIgnoreCase(taskForm.getDatasource().getDatabaseType()) && ConnectMethodEnum.INSTANCENAME.getName().equalsIgnoreCase(taskForm.getDatasource().getConnectMethod())) {
                taskForm.getDatasource().setDatabaseDriver(this.dbProperties.getSqlServerDriver());
                taskForm.getDatasource().setDatabaseUrl(String.format(this.dbUrlUtil.getSqlServerUrlByInstance(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName()));
            }
            if (DbTypeEnum.ORACLE.getType().equalsIgnoreCase(taskForm.getDatasource().getDatabaseType()) && ConnectMethodEnum.SID.getName().equalsIgnoreCase(taskForm.getDatasource().getConnectMethod())) {
                taskForm.getDatasource().setDatabaseDriver(this.dbProperties.getOracleDriver());
                taskForm.getDatasource().setDatabaseUrl(String.format(this.dbUrlUtil.getOracleUrlBySid(), taskForm.getDatasource().getDatabaseIp().trim(), taskForm.getDatasource().getDatabasePort().trim(), taskForm.getDatasource().getDatabaseName().trim()));
            }
            if (DbTypeEnum.ORACLE.getType().equalsIgnoreCase(taskForm.getDatasource().getDatabaseType()) && ConnectMethodEnum.SERVICENAME.getName().equalsIgnoreCase(taskForm.getDatasource().getConnectMethod())) {
                taskForm.getDatasource().setDatabaseDriver(this.dbProperties.getOracleDriver());
                taskForm.getDatasource().setDatabaseUrl(String.format(this.dbUrlUtil.getOracleUrlByServiceName(), taskForm.getDatasource().getDatabaseIp().trim(), taskForm.getDatasource().getDatabasePort().trim(), taskForm.getDatasource().getDatabaseName().trim()));
            }
            if (DbTypeEnum.ORACLE.getType().equalsIgnoreCase(taskForm.getDatasource().getDatabaseType()) && ConnectMethodEnum.TNSNAME.getName().equalsIgnoreCase(taskForm.getDatasource().getConnectMethod())) {
                taskForm.getDatasource().setDatabaseDriver(this.dbProperties.getOracleDriver());
                taskForm.getDatasource().setDatabaseUrl(String.format(this.dbUrlUtil.getOracleUrlByTnsName(), taskForm.getDatasource().getDatabaseName().trim()));
            }
        }
    }

    public String getUrl(CdiProperties.Task taskForm) {
        if (DbTypeEnum.MYSQL.getType().equals(taskForm.getDatasource().getDatabaseType())) {
            return String.format(this.dbUrlUtil.getMySqlUrl(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName());
        }
        if (DbTypeEnum.ORACLE.getType().equals(taskForm.getDatasource().getDatabaseType())) {
            if (ConnectMethodEnum.SID.getName().equals(taskForm.getDatasource().getDatabaseType())) {
                return String.format(this.dbUrlUtil.getOracleUrlBySid(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName());
            }
            if (ConnectMethodEnum.SERVICENAME.getName().equals(taskForm.getDatasource().getConnectMethod())) {
                return String.format(this.dbUrlUtil.getOracleUrlByServiceName(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName());
            }
            if (ConnectMethodEnum.TNSNAME.getName().equals(taskForm.getDatasource().getConnectMethod())) {
                return String.format(this.dbUrlUtil.getOracleUrlByTnsName(), taskForm.getDatasource().getDatabaseName());
            }
            if (ConnectMethodEnum.PORT.getName().equals(taskForm.getDatasource().getConnectMethod())) {
                return String.format(this.dbUrlUtil.getOracleUrlByPort(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName());
            }
        }
        if (DbTypeEnum.SQLSERVER.getType().equals(taskForm.getDatasource().getDatabaseType())) {
            if (ConnectMethodEnum.PORT.getName().equals(taskForm.getDatasource().getConnectMethod())) {
                return String.format(this.dbUrlUtil.getSqlServerUrl(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName());
            }
            if (ConnectMethodEnum.INSTANCENAME.getName().equals(taskForm.getDatasource().getConnectMethod())) {
                return String.format(this.dbUrlUtil.getSqlServerUrlByInstance(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName());
            }
        }
        if (DbTypeEnum.SYBASE.getType().equals(taskForm.getDatasource().getDatabaseType())) {
            return String.format(this.dbUrlUtil.getSybaseUrl(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName());
        }
        if (DbTypeEnum.POSTGRESQL.getType().equals(taskForm.getDatasource().getDatabaseType())) {
            return String.format(this.dbUrlUtil.getPostgreSqlUrl(), taskForm.getDatasource().getDatabaseIp(), taskForm.getDatasource().getDatabasePort(), taskForm.getDatasource().getDatabaseName());
        }
        if (DbTypeEnum.SQLITE.getType().equals(taskForm.getDatasource().getDatabaseType())) {
            return String.format(this.dbUrlUtil.getSqlLiteUrl(), taskForm.getDatasource().getDatabaseFilePath());
        }
        return "";
    }

    public static String getDriver(String databaseType, DbProperties dbProperties) {
        if (DbTypeEnum.MYSQL.getType().equals(databaseType)) {
            return dbProperties.getMysqlDriver();
        }
        if (DbTypeEnum.ORACLE.getType().equals(databaseType)) {
            return dbProperties.getOracleDriver();
        }
        if (DbTypeEnum.SQLSERVER.getType().equals(databaseType)) {
            return dbProperties.getSqlServerDriver();
        }
        if (DbTypeEnum.SYBASE.getType().equals(databaseType)) {
            return dbProperties.getSybaseDriver();
        }
        if (DbTypeEnum.POSTGRESQL.getType().equals(databaseType)) {
            return dbProperties.getPostgreSqlDriver();
        }
        if (DbTypeEnum.SQLITE.getType().equals(databaseType)) {
            return dbProperties.getSqlLiteDriver();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnect(CdiProperties.Task taskForm) {
        String url = this.getUrl(taskForm);
        String userName = taskForm.getDatasource().getDatabaseUsername();
        String passWord = taskForm.getDatasource().getDatabasePassword();
        String sql = taskForm.getDatasource().getDatabaseSql();
        String driver = DBUtil.getDriver(taskForm.getDatasource().getDatabaseType(), this.dbProperties);
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = DBUtil.getConnect(driver, url, userName, passWord);
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, stmt, rs);
                throw throwable;
            }
            DBUtil.close(conn, stmt, rs);
        }
        DBUtil.close(conn, stmt, rs);
        return rs != null;
    }

    public static void close(Connection conn, Statement stat, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (stat != null) {
                stat.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

