/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import com.hanshow.cdi.util.OkHttpsClientWrap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpClientWrap {
    private static final Logger log = LogManager.getLogger(HttpClientWrap.class);
    private static volatile OkHttpClient httpClient = null;
    private static final String JSON_MEDIA_TYPE_PATTERN = "application/json; charset=%s";

    public static OkHttpClient getInstance() {
        return HttpClientWrap.getInstance(0);
    }

    public static boolean getStatus() {
        return httpClient == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient getInstance(int timeout) {
        if (httpClient != null) return httpClient;
        Class<OkHttpsClientWrap> clazz = OkHttpsClientWrap.class;
        synchronized (OkHttpsClientWrap.class) {
            if (httpClient != null) return httpClient;
            try {
                httpClient = timeout == 0 ? HttpClientWrap.getHttpClient(61) : HttpClientWrap.getHttpClient(timeout);
            }
            catch (Exception e) {
                log.error("Create http sender error ", (Throwable)e);
            }
            return httpClient;
        }
    }

    private HttpClientWrap() {
    }

    public static void destroy() {
        httpClient = null;
    }

    private static OkHttpClient getHttpClient(int timeout) {
        return new OkHttpClient.Builder().readTimeout(timeout, TimeUnit.SECONDS).connectTimeout(timeout, TimeUnit.SECONDS).writeTimeout(timeout, TimeUnit.SECONDS).build();
    }

    public static String postJsonToURL(String url, String string, String charset) throws IOException {
        return HttpClientWrap.postJsonToURL(url, string, charset, false);
    }

    public static String postJsonToURL(String url, String string, String charset, boolean gzip) throws IOException {
        byte[] bytes;
        if (gzip) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream zipper = new GZIPOutputStream(baos);
            ((OutputStream)zipper).write(string.getBytes(charset));
            ((OutputStream)zipper).close();
            bytes = baos.toByteArray();
        } else {
            bytes = string.getBytes(charset);
        }
        MediaType JSON2 = MediaType.parse(String.format(JSON_MEDIA_TYPE_PATTERN, charset));
        RequestBody body = RequestBody.create(JSON2, bytes);
        Request request = gzip ? new Request.Builder().url(url).post(body).header("Content-Encoding", "gzip").build() : new Request.Builder().url(url).post(body).build();
        Response response = httpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        response.close();
        throw new IOException(String.format("Post JSON to url %s got unexpected code %d DATA %s", url, response.code(), string));
    }

    public static String getURL(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        Response response = httpClient.newCall(request).execute();
        if (response.isSuccessful()) {
            return response.body().string();
        }
        response.close();
        throw new IOException(String.format("get to url %s got unexpected code %s message %s", url, response.code(), response.message()));
    }
}

