/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonSchemaUtil {
    private static final Logger log = LogManager.getLogger(JsonSchemaUtil.class);

    public static JsonNode strToJsonNode(String jsonStr) {
        JsonNode jsonNode = null;
        try {
            jsonNode = JsonLoader.fromString(jsonStr);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return jsonNode;
    }

    public static Map<Integer, Map<String, Object>> getPrismartProcessingReport(JsonNode jsonNode, JsonSchema prismartschema) throws Exception {
        LinkedHashMap<Integer, Map<String, Object>> map = new LinkedHashMap<Integer, Map<String, Object>>();
        Set<ValidationMessage> validationMessages = prismartschema.validate(jsonNode);
        validationMessages.forEach(validationMessage -> {
            String message = validationMessage.getMessage();
            int index = Integer.parseInt(message.substring(message.indexOf("items[") + "items".length() + 1, message.indexOf("]")));
            if (map.containsKey(index)) {
                ((List)((Map)map.get(index)).get("failedMsg")).add(message);
            } else {
                LinkedHashMap msg = new LinkedHashMap();
                ArrayList<String> errorMsg = new ArrayList<String>();
                errorMsg.add(message);
                msg.put("failedMsg", errorMsg);
                map.put(index, msg);
            }
        });
        return map;
    }
}

