/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonStructureParsingUtils {
    private static final Logger log = LogManager.getLogger(JsonStructureParsingUtils.class);
    public static final Set<String> fields = new HashSet<String>();

    public static void main(String[] args) throws IOException {
        String jsonString = "{\n    \"source\": \"IG/initialload\",\n    \"batchid\": 1679293631282,\n    \"time\": \"2023-03-20T06:27:11.282Z\",\n    \"data\": [\n        {\n            \"brand\": \"GAMMA\",\n            \"brandLogo\": \"https://static.gamma.nl/dam/11894/9\",\n            \"currency\": \"EUR\",\n            \"ean\": \"8711247775812\",\n            \"ecoCheque\": false,\n            \"pricePackage\": false,\n            \"segment\": \"18\",\n            \"shelfLocations\": [\n                {\n                    \"shelfUid\": \"18.03-002001\",\n                    \"showModelReference\": \"0\",\n                    \"planogramid\": \"hdo345\"\n                },\n                {\n                    \"shelfUid\": \"18.03-002002\",\n                    \"showModelReference\": \"1\",\n                    \"planogramid\": \"hdo345\"\n                }\n            ],\n            \"subTitle\": \"350W TRIMMERS NL\",\n            \"supplier\": \"EVDTI\",\n            \"title\": \"SPOELEN VOOR 250W/\",\n            \"usps\": \"8 meter draad\",\n            \"useAdvicePrice\": \"false\",\n            \"advicePrice\": 7.99,\n            \"adviceUnitPrice\": 7.99,\n            \"useLowestPrice30Days\": \"true\",\n            \"lowestPrice30Days\": 5.15,\n            \"lowestUnitPrice30Days\": 5.15,\n            \"outOfStock\": false,\n            \"customerReview\": {\n                \"rating\": 4.9,\n                \"reviewCount\": 9\n            },\n            \"description\": \"<p>De grastrimmerspoel beschikt over 8 meter draad en is gemakkelijk te verwisselen. Deze spoel is geschikt voor grastrimmers met typenummers: GT350T / GT252S / GT18T / GT-250N / GTI-253S / GTK-353S.</p>\",\n            \"id\": \"456132\",\n            \"multimedia\": {\n                \"image\": \"https://static.gamma.nl/dam/27114/41\",\n                \"picto\": \"https://static.gamma.nl/dam/27114/21\",\n                \"url\": \"https://www.gamma.nl/p/B456132\"\n            },\n            \"name\": \"GAMMA grastrimspoel 8 meter draad\",\n            \"regular\": {\n                \"regular_price\": 7.89,\n                \"unitPrice\": {\n                    \"regular_unit_price\": 4.99,\n                    \"unit\": \"liter\"\n                }\n            },\n            \"promotion\": {\n                \"promotion_price\": 7.89,\n                \"unitPrice\": {\n                    \"promotion_unit_price\": 4.99,\n                    \"unit\": \"liter\"\n                },\n                \"label\": {\n                    \"label_name\": \"25% Korting\",\n                    \"imageUrl\": \"https://static.gamma.nl/dam/474486/150\"\n                }\n            }\n        },\n        {\n            \"brand\": \"GAMMA\",\n            \"brandLogo\": \"https://static.gamma.nl/dam/11894/9\",\n            \"currency\": \"EUR\",\n            \"ean\": \"8711247775812\",\n            \"ecoCheque\": false,\n            \"pricePackage\": false,\n            \"segment\": \"18\",\n            \"shelfLocations\": [\n                {\n                    \"shelfUid\": \"18.03-002001\",\n                    \"showModelReference\": \"0\",\n                    \"planogramid\": \"hdo345\"\n                },\n                {\n                    \"shelfUid\": \"18.03-002002\",\n                    \"showModelReference\": \"1\",\n                    \"planogramid\": \"hdo345\"\n                }\n            ],\n            \"subTitle\": \"350W TRIMMERS NL\",\n            \"supplier\": \"EVDTI\",\n            \"title\": \"SPOELEN VOOR 250W/\",\n            \"usps\": \"8 meter draad\",\n            \"useAdvicePrice\": \"false\",\n            \"advicePrice\": 7.99,\n            \"adviceUnitPrice\": 7.99,\n            \"useLowestPrice30Days\": \"true\",\n            \"lowestPrice30Days\": 5.15,\n            \"lowestUnitPrice30Days\": 5.15,\n            \"outOfStock\": false,\n            \"customerReview\": {\n                \"rating\": 4.9,\n                \"reviewCount\": 9\n            },\n            \"description\": \"<p>De grastrimmerspoel beschikt over 8 meter draad en is gemakkelijk te verwisselen. Deze spoel is geschikt voor grastrimmers met typenummers: GT350T / GT252S / GT18T / GT-250N / GTI-253S / GTK-353S.</p>\",\n            \"id\": \"456132\",\n            \"multimedia\": {\n                \"image\": \"https://static.gamma.nl/dam/27114/41\",\n                \"picto\": \"https://static.gamma.nl/dam/27114/21\",\n                \"url\": \"https://www.gamma.nl/p/B456132\"\n            },\n            \"name\": \"GAMMA grastrimspoel 8 meter draad\",\n            \"regular\": {\n                \"regular_price\": 7.89,\n                \"unitPrice\": {\n                    \"regular_unit_price\": 4.99,\n                    \"unit\": \"liter\"\n                }\n            },\n            \"promotion\": {\n                \"promotion_price\": 7.89,\n                \"unitPrice\": {\n                    \"promotion_unit_price\": 4.99,\n                    \"unit\": \"liter\"\n                },\n                \"label\": {\n                    \"label_name\": \"25% Korting\",\n                    \"imageUrl\": \"https://static.gamma.nl/dam/474486/150\"\n                }\n            }\n        }\n    ]\n}";
        JsonNode root = new ObjectMapper().readTree(jsonString);
        JsonStructureParsingUtils.getJsonFields(root, "/");
        System.out.println(fields);
    }

    public static void getJsonFields(JsonNode node, String fatherName) {
        if (node.isObject()) {
            node.fields().forEachRemaining(entry -> {
                AtomicReference<String> name = new AtomicReference<String>(fatherName);
                name.set(name + "." + (String)entry.getKey());
                fields.add(String.valueOf(name));
                System.out.println(name + ": ");
                JsonStructureParsingUtils.getJsonFields((JsonNode)entry.getValue(), String.valueOf(name));
            });
        } else if (node.isArray()) {
            System.out.println("    ");
            AtomicReference<String> name = new AtomicReference<String>(fatherName);
            node.elements().forEachRemaining(element -> JsonStructureParsingUtils.getJsonFields(element, String.valueOf(name)));
        } else {
            System.out.println("    " + node.asText());
        }
    }
}

