/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import com.hanshow.intsmart.centre.InitializeContext;
import java.io.IOException;
import java.net.ConnectException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrismartSender {
    private static final Logger log = LogManager.getLogger(PrismartSender.class);
    @Autowired
    private InitializeContext initializeContext;

    public String getPrismartApi(String integrationUrl) {
        String response = "";
        try {
            if (integrationUrl.toUpperCase().startsWith("HTTPS")) {
                response = this.initializeContext.getServerContext().getOkHttpsClientWrap().getUrl(integrationUrl, "UTF-8");
            } else if (integrationUrl.toUpperCase().startsWith("HTTP")) {
                response = this.initializeContext.getServerContext().getOkHttpClientWrap().getUrl(integrationUrl, "UTF-8");
            }
        }
        catch (ConnectException ce) {
            log.error("Get prismart api {} failed due to cannot connect prismart node.", (Object)integrationUrl, (Object)ce);
        }
        catch (Exception e) {
            log.error("Get prismart api {} failed.", (Object)integrationUrl, (Object)e);
        }
        return response;
    }

    public String sendPrismart(String url, String customerStoreCode, String data) throws IOException {
        String prismartResponse = "";
        if (url.toUpperCase().startsWith("HTTPS")) {
            prismartResponse = this.initializeContext.getServerContext().getOkHttpsCertClientWrapMap().containsKey(customerStoreCode) ? this.initializeContext.getServerContext().getOkHttpsCertClientWrapMap().get(customerStoreCode).postJsonToURL(url, data, this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getCharset()) : this.initializeContext.getServerContext().getOkHttpsClientWrap().postJsonToURL(url, data, this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getCharset());
        } else if (url.toUpperCase().startsWith("HTTP")) {
            prismartResponse = this.initializeContext.getServerContext().getOkHttpClientWrap().postJsonToURL(url, data, this.initializeContext.getServerContext().getCdiProperties().getCdiSystem().getCharset());
        }
        return prismartResponse;
    }
}

