/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.intsmart.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Version {
    private static final Logger log = LogManager.getLogger(Version.class);
    private static SimpleDateFormat batchDateFormat = new SimpleDateFormat("yyyyMMdd");
    private String moudleName = "Intsmart";
    private String copyright = "Hanshow .Inc";
    private String stage = "beta10";
    private int major = numberEnum.THREE.getNumber();
    private int minor = numberEnum.ZERO.getNumber();
    private int revision = numberEnum.ZERO.getNumber();
    private String build = this.formatBuild("20250214");
    private String versionByCore = String.format("%s %s.%s-%s", this.moudleName, this.major, this.minor, this.stage);
    private String versionByInner = String.format("%s.%s.%s", this.major, this.minor, this.revision);
    private String applicableVersion = "Shopweb1.7.0+";

    public static void main(String[] args) {
        Version.getVersion();
    }

    public static void getVersion() {
        Version version = new Version();
        log.info("--------------------------------------------------------------------------------");
        log.info("|");
        log.info(String.format("|               version : %s", version.getVersionByCore()));
        log.info("|               Applicable Version : " + version.getApplicableVersion());
        log.info("|               @CopyRight : " + version.getCopyright());
        log.info("|");
        log.info("--------------------------------------------------------------------------------");
    }

    public String getApplicableVersion() {
        return this.applicableVersion;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getVersionByCore() {
        return this.versionByCore;
    }

    public String getVersionByInner() {
        return this.versionByInner;
    }

    private String formatBuild(String date) {
        try {
            batchDateFormat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    private static enum numberEnum {
        ZERO(0),
        ONE(1),
        TWO(2),
        FOUR(4),
        THREE(3),
        FIVE(5),
        SIX(6),
        EIGHT(8),
        SEVEN(7),
        NINE(9);

        private int number;

        private numberEnum(int stage) {
            this.number = stage;
        }

        public int getNumber() {
            return this.number;
        }
    }

    private static enum stageEnum {
        ALPHA("Alpha"),
        BETA("Beta"),
        RC("RC"),
        RELEASE("Release");

        private String stageName;

        private stageEnum(String stage) {
            this.stageName = stage;
        }

        public String getStageName() {
            return this.stageName;
        }
    }
}

