/*
 * Decompiled with CFR 0.152.
 */
package resolve.util;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.util.Args;

public class ResolveCvs {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wirteCsv(List<String[]> listData, File file, String charsetName, char separator, char quotechar) {
        FileOutputStream fos = null;
        CSVWriter csvWriter = null;
        Writer writer = null;
        try {
            fos = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)fos, charsetName);
            csvWriter = new CSVWriter(writer, separator, quotechar);
            csvWriter.writeAll(listData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (csvWriter != null) {
                    csvWriter.close();
                }
                if (writer != null) {
                    writer.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wirteCsvNext(List<String[]> listData, File file, String charsetName, char separator, char quotechar) {
        FileOutputStream fos = null;
        CSVWriter csvWriter = null;
        Writer writer = null;
        try {
            fos = new FileOutputStream(file, true);
            writer = new OutputStreamWriter((OutputStream)fos, charsetName);
            csvWriter = new CSVWriter(writer, separator, quotechar);
            csvWriter.writeAll(listData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (csvWriter != null) {
                    csvWriter.close();
                }
                if (writer != null) {
                    writer.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<String[]> readCvsFile(String filePath, String fileEncoding, char separator, char quotechar, int skipline) {
        ArrayList<String[]> result = null;
        if (filePath != null && !filePath.isEmpty()) {
            try {
                FileInputStream fio = new FileInputStream(filePath);
                DataInputStream in = new DataInputStream(fio);
                CSVReader reader = new CSVReader((Reader)new InputStreamReader((InputStream)in, fileEncoding), separator, quotechar, skipline);
                String[] nextLine = null;
                result = new ArrayList<String[]>();
                while ((nextLine = reader.readNext()) != null) {
                    result.add(nextLine);
                }
                reader.close();
                in.close();
                fio.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static List<String[]> readCvsFile(String filePath, String fileEncoding, char separator, char quotechar, int skipline, int startIndex, int length) {
        Args.notEmpty((CharSequence)filePath, (String)"filePath");
        Args.notEmpty((CharSequence)fileEncoding, (String)"fileEncoding");
        ArrayList<String[]> result = null;
        if (filePath != null && !filePath.isEmpty()) {
            try {
                FileInputStream fio = new FileInputStream(new File(filePath));
                DataInputStream in = new DataInputStream(fio);
                CSVReader reader = new CSVReader((Reader)new InputStreamReader((InputStream)in, fileEncoding), separator, quotechar, skipline);
                String[] nextLine = null;
                result = new ArrayList<String[]>();
                while ((nextLine = reader.readNext()) != null) {
                    String[] newArray = new String[length];
                    System.arraycopy(nextLine, startIndex, newArray, 0, length);
                    result.add(newArray);
                }
                reader.close();
                in.close();
                fio.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

