/*
 * Decompiled with CFR 0.152.
 */
package resolve.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;

public class ResolveExcel {
    private static int scale = 2;
    private static String format = "yyyy-MM-dd";

    public static void setScale(int scale) {
        ResolveExcel.scale = scale;
    }

    public static void setFormat(String format) {
        ResolveExcel.format = format;
    }

    public static List<String[]> readXLSByRow(String filePath, int sheetIndex, int rowsStart, int rowsNum) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        ArrayList<String[]> datas = new ArrayList<String[]>();
        File file = new File(filePath);
        Sheet sheet = null;
        try (FileInputStream fis = new FileInputStream(file);
             Workbook wb = WorkbookFactory.create((InputStream)fis);){
            int rowEnd;
            sheet = wb.getSheetAt(sheetIndex);
            if (rowsStart < 0) {
                rowsStart = sheet.getFirstRowNum();
                rowEnd = sheet.getLastRowNum();
            } else {
                rowsStart = rowsStart > sheet.getLastRowNum() ? sheet.getLastRowNum() : rowsStart;
                rowEnd = rowsStart + rowsNum - 1 > sheet.getLastRowNum() ? sheet.getLastRowNum() : rowsStart + rowsNum - 1;
            }
            for (int i = rowsStart; i <= rowEnd; ++i) {
                Row row = sheet.getRow(i);
                if (row == null || row.getLastCellNum() <= 0) continue;
                int cellStart = row.getFirstCellNum();
                short cellEnd = row.getLastCellNum();
                String[] cells = new String[cellEnd];
                for (int j = cellStart; j <= cellEnd; ++j) {
                    Cell cell = row.getCell(j);
                    if (cell == null) continue;
                    CellType cellType = cell.getCellType();
                    String cellValue = "";
                    switch (cellType) {
                        case NUMERIC: {
                            cellValue = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                            break;
                        }
                        case FORMULA: {
                            try {
                                cellValue = cell.getStringCellValue();
                            }
                            catch (IllegalStateException e) {
                                cellValue = new BigDecimal(cell.getNumericCellValue()).setScale(scale, RoundingMode.HALF_UP).toPlainString();
                            }
                            break;
                        }
                        case BOOLEAN: {
                            cellValue = String.valueOf(cell.getBooleanCellValue());
                            break;
                        }
                        default: {
                            try {
                                cellValue = cell.getStringCellValue();
                                break;
                            }
                            catch (Exception e) {
                                System.out.println(i + "-" + j + "-" + cellValue);
                            }
                        }
                    }
                    cells[j] = cellValue.trim();
                }
                datas.add(cells);
            }
        }
        return datas;
    }
}

