/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cryptor;

import com.hanshow.cryptor.GenerateAESKey;
import com.hanshow.cryptor.HsCyptor;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DefaultCryptor
implements HsCyptor {
    private static String ALGORITHM = "AES/CBC/PKCS5Padding";
    private static String SECRET_KEY = "";
    private static DefaultCryptor instance;

    private DefaultCryptor(String secretKey) {
        SECRET_KEY = secretKey;
        System.out.println("DefaultCryptor: " + SECRET_KEY);
    }

    public static DefaultCryptor getInstance(String secretKey) {
        if (instance == null) {
            instance = new DefaultCryptor(secretKey);
        }
        return instance;
    }

    @Override
    public String encrypt(String plainText, String iv) throws Exception {
        if (iv == null) {
            iv = GenerateAESKey.generateIV();
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(GenerateAESKey.hexToByteArray(iv));
        SecretKeySpec secretKeySpec = new SecretKeySpec(GenerateAESKey.hexToByteArray(SECRET_KEY), "AES");
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
        byte[] encrypted = cipher.doFinal(plainText.getBytes());
        return GenerateAESKey.bytesToHex(encrypted) + "." + iv;
    }

    @Override
    public String decrypt(String encryptedText, String iv) throws Exception {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(GenerateAESKey.hexToByteArray(iv));
        SecretKeySpec secretKeySpec = new SecretKeySpec(GenerateAESKey.hexToByteArray(SECRET_KEY), "AES");
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        byte[] decrypted = cipher.doFinal(GenerateAESKey.hexToByteArray(encryptedText));
        return new String(decrypted);
    }
}

