#!/bin/sh
# chkconfig: 2345 90 10
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# -----------------------------------------------------------------------------
# Commons Daemon wrapper script.
# -----------------------------------------------------------------------------
#

JAVA_HOME=/data/hanshow/java/jdk-17.0.2
[ -z "$APP_HOME" ] && APP_HOME=/data/hanshow/integration/Hanshow-IntSmart3.0-beta07
[ -z "$APP_USER" ] && APP_USER=root
[ -z "$JVM_FLAGS" ] && JVM_FLAGS="-Xms2048m -Xmx2048m"
ARGS=

# resolve links - $0 may be a softlink
ARG0="$0"
while [ -h "$ARG0" ]; do
  ls=`ls -ld "$ARG0"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    ARG0="$link"
  else
    ARG0="`dirname $ARG0`/$link"
  fi
done
DIRNAME="`dirname $ARG0`"
PROGRAM="`basename $ARG0`"
while [ ".$1" != . ]
do
  case "$1" in
    --java-home )
        JAVA_HOME="$2"
        shift; shift;
        continue
    ;;
    --app-home )
        APP_HOME="$2"
        shift; shift;
        continue
    ;;
    --app-user )
        APP_USER="$2"
        shift; shift;
        continue
    ;;
    --app-pid )
        APP_PID="$2"
        shift; shift;
        continue
    ;;
    --service-start-wait-time )
        SERVICE_START_WAIT_TIME="$2"
        shift; shift;
        continue
    ;;
    * )
        break
    ;;
  esac
done

# Use the maximum available, or set MAX_FD != -1 to use that
test ".$MAX_FD" = . && MAX_FD="maximum"
# Setup parameters for running the jsvc
#
test ".$APP_USER" = . && APP_USER=root

# Set JAVA_HOME to working JDK or JRE
# JAVA_HOME=/opt/jdk-1.6.0.22
# If not set we'll try to guess the JAVA_HOME
# from java binary if on the PATH
#
if [ -z "$JAVA_HOME" ]; then
    JAVA_BIN="`which java 2>/dev/null || type java 2>&1`"
    test -x "$JAVA_BIN" && JAVA_HOME="`dirname $JAVA_BIN`"
    test ".$JAVA_HOME" != . && JAVA_HOME=`cd "$JAVA_HOME/.." >/dev/null; pwd`
else
    JAVA_BIN="$JAVA_HOME/bin/java"
fi

# Only set APP_HOME if not already set
test ".$APP_HOME" = . && APP_HOME=`cd "$DIRNAME/.." >/dev/null; pwd`
test ".$APP_MAIN" = . && APP_MAIN=com.hanshow.intsmart.Bootstrap
# If not explicitly set, look for jsvc in CATALINA_BASE first then CATALINA_HOME
if [ -z "$JSVC" ]; then
    JSVC="$APP_HOME/bin/jsvc"
fi
# Set the default service-start wait time if necessary
test ".$SERVICE_START_WAIT_TIME" = . && SERVICE_START_WAIT_TIME=10

# Ensure that any user defined CLASSPATH variables are not used on startup,
# but allow them to be specified in setenv.sh, in rare case when it is needed.
CLASSPATH="$APP_HOME/config:$APP_HOME/lib/*"
JAVA_OPTS="-Duser.language=en -Djava.security.egd=file:/dev/./urandom -Dfile.encoding=UTF-8  $JVM_FLAGS -Dintegration.home=$APP_HOME "

# Add on extra jar files to CLASSPATH
test ".$CLASSPATH" != . && CLASSPATH="${CLASSPATH}:"
CLASSPATH="$CLASSPATH$APP_HOME/config:$APP_HOME/bin/commons-daemon-1.2.4.jar"

test ".$APP_OUT" = . && APP_OUT="/dev/null"

# Set -pidfile
test ".$APP_PID" = . && APP_PID="$APP_HOME/integration-daemon.pid"

# ----- Execute The Requested Command -----------------------------------------
case "$1" in
    run     )
      shift
      "$JSVC" $* \
      -java-home "$JAVA_HOME" \
      -pidfile "$APP_PID" \
      -wait "$SERVICE_START_WAIT_TIME" \
      -nodetach \
      -outfile "&1" \
      -errfile "&2" \
      -cwd "$APP_HOME" \
      -classpath "$CLASSPATH" \
      $JAVA_OPTS \
      -Dintegration.home="$APP_HOME" \
      $APP_MAIN \
      $ARGS
      exit $?
    ;;
    start   )
      "$JSVC" \
      -java-home "$JAVA_HOME" \
      -user $APP_USER \
      -pidfile "$APP_PID" \
      -wait "$SERVICE_START_WAIT_TIME" \
	  -cwd "$APP_HOME" \
      -outfile "$APP_OUT" \
      -errfile "&2" \
      -classpath "$CLASSPATH" \
      $JAVA_OPTS \
      -Dintegration.home="$APP_HOME" \
      $APP_MAIN \
      $ARGS
      exit $?
    ;;
    stop    )
      "$JSVC" \
      -stop \
      -pidfile "$APP_PID" \
      -classpath "$CLASSPATH" \
      -Dintegration.home="$APP_HOME" \
      $APP_MAIN
      exit $?
    ;;
    version  )
      "$JSVC" \
      -java-home "$JAVA_HOME" \
      -pidfile "$APP_PID" \
      -classpath "$CLASSPATH" \
      -errfile "&2" \
      -version \
      -check \
      $APP_MAIN
      exit $?
    ;;
    *       )
      echo "Unknown command: \`$1'"
      echo "Usage: $PROGRAM ( commands ... )"
      echo "commands:"
      echo "  run               Start integration without detaching from console"
      echo "  start             Start integration"
      echo "  stop              Stop integration"
      echo "  version           What version of commons daemon and integration"
      echo "                    are you running?"
      exit 1
    ;;
esac

