/*
 * Decompiled with CFR 0.152.
 */
package resolve.main;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import resolve.util.FileUtil;
import resolve.util.HttpUtil;
import resolve.util.ResolveCvs;
import resolve.util.ResolveExcel;

public class ResolveFile {
    public static List<String[]> ReadCSV(String filePath, String fileEncoding, char separator, char quotechar, int skipline) {
        return ResolveCvs.readCvsFile(filePath, fileEncoding, separator, quotechar, skipline);
    }

    public static List<String[]> ReadCSV(String filePath, String fileEncoding, char separator, char quotechar, int skipline, int startIndex, int length) {
        return ResolveCvs.readCvsFile(filePath, fileEncoding, separator, quotechar, skipline, startIndex, length);
    }

    public static List<String[]> ReadExcel(String filePath, int sheetIndex, int rowsStart, int lineNum) throws IOException {
        if (rowsStart < 0 || lineNum <= 0) {
            return new ArrayList<String[]>();
        }
        return ResolveExcel.readXLSByRow(filePath, sheetIndex, rowsStart, lineNum);
    }

    public static List<String[]> ReadExcel(String filePath, int sheetIndex) throws IOException {
        return ResolveExcel.readXLSByRow(filePath, sheetIndex, -1, 0);
    }

    public static void DownLoad(String path, String url, int timeout) throws Exception {
        HttpUtil.downloadFile(path, url, timeout);
    }

    public static void WriteCsv(List<String[]> listData, File file, String charsetName, char separator, char quotechar) {
        ResolveCvs.wirteCsv(listData, file, charsetName, separator, quotechar);
    }

    public static void WriteCsvNext(List<String[]> listData, File file, String charsetName, char separator, char quotechar) {
        ResolveCvs.wirteCsvNext(listData, file, charsetName, separator, quotechar);
    }

    public static List<String> readBigTxt(File file, String encoding, long pos, int num, String fileEncoding) {
        List pins;
        Map<String, Object> res;
        ArrayList<String> lines = new ArrayList<String>();
        while (!MapUtils.isEmpty(res = FileUtil.BufferedRandomAccessFileReadLine(file, encoding, pos, num, fileEncoding)) && CollectionUtils.isNotEmpty((Collection)(pins = (List)res.get("pins")))) {
            lines.addAll(pins);
            if (pins.size() < num) break;
            pos = (Long)res.get("pos");
        }
        return lines;
    }
}

