/*
 * Decompiled with CFR 0.152.
 */
package resolve.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.Args;

public class HttpUtil {
    public static void downloadFile(String path, String url, int timeout) throws Exception {
        block19: {
            Args.notNull((Object)path, (String)"path");
            Args.notNull((Object)url, (String)"url");
            CloseableHttpClient client = null;
            try {
                Header[] headers;
                client = HttpClients.createDefault();
                HttpGet httpGet = new HttpGet(url);
                RequestConfig bf = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).build();
                httpGet.setConfig(bf);
                CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)httpGet);
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 200) {
                    long length;
                    HttpEntity entity = closeableHttpResponse.getEntity();
                    InputStream instream = entity.getContent();
                    if (instream == null) {
                        // empty if block
                    }
                    Args.check(((length = entity.getContentLength()) <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"HTTP resolve.entity too large to be buffered in memory");
                    FilterOutputStream bfo = null;
                    try {
                        byte[] tmp = new byte[0x100000];
                        bfo = new BufferedOutputStream(new FileOutputStream(path));
                        int index = 0;
                        while ((index = instream.read(tmp)) != -1) {
                            ((BufferedOutputStream)bfo).write(tmp, 0, index);
                        }
                        break block19;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        instream.close();
                        bfo.close();
                    }
                }
                StringBuffer errorMsg = new StringBuffer();
                errorMsg.append("httpStatus:");
                errorMsg.append(closeableHttpResponse.getStatusLine().getStatusCode());
                errorMsg.append(closeableHttpResponse.getStatusLine().getReasonPhrase());
                errorMsg.append(", Header: ");
                for (Header header : headers = closeableHttpResponse.getAllHeaders()) {
                    errorMsg.append(header.getName());
                    errorMsg.append(":");
                    errorMsg.append(header.getValue());
                }
            }
            catch (ClientProtocolException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    client.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

