/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi;

import com.hanshow.cdi.core.GenericCdiServerContext;
import com.hanshow.cdi.core.UploadedFileProcessor;
import com.hanshow.cdi.ftp.FtpServerWrap;
import com.hanshow.cdi.listener.FileUploadedListener;
import com.hanshow.cdi.listener.MsgFileListener;
import com.hanshow.cdi.properties.CdiProperties;
import com.hanshow.cdi.service.CdiService;
import com.hanshow.cdi.service.StoreService;
import java.io.FileFilter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang.StringUtils;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenericCdiServer {
    private static final Logger log = LogManager.getLogger(GenericCdiServer.class);
    private FtpServerWrap ftpServer;
    private UploadedFileProcessor processor;
    private FileUploadedListener listener;
    private FileAlterationMonitor monitor;

    public void start(CdiService cdiService, GenericCdiServerContext serverContext, StoreService storeService, int ftpMaxLogins) throws Exception {
        this.processor = new UploadedFileProcessor(4, serverContext, cdiService, storeService);
        this.listener = new FileUploadedListener(serverContext, this.processor);
        if (serverContext.getCdiSystem().isCdiFtpSwitch()) {
            this.ftpServer = new FtpServerWrap(serverContext.getCdiFtpAddress());
            this.ftpServer.start(serverContext.getFtpUsersPropertiesFile(), this.listener, ftpMaxLogins);
        } else {
            long intervalTime = TimeUnit.SECONDS.toMillis(5L);
            FileAlterationObserver observer = new FileAlterationObserver(serverContext.getMsgDir(), (FileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.suffixFileFilter((String)".hanshow_msg")}));
            observer.addListener((FileAlterationListener)new MsgFileListener(serverContext, this.processor));
            this.monitor = new FileAlterationMonitor(intervalTime, new FileAlterationObserver[]{observer});
            try {
                this.monitor.start();
            }
            catch (Exception e) {
                log.error("create local dir monitor error : {}", (Object)e.getMessage(), (Object)e);
                System.exit(-1);
            }
        }
        Map<String, Map<String, CdiProperties.Field>> map = serverContext.getTaskServerFieldsNameMap();
        log.info("================================================================================");
        log.info("Hanshow CDI Springboot Stater");
        log.info("version: 4.0.0");
        log.info("locale=" + serverContext.getLocale());
        log.info("charset=" + serverContext.getCdiSystem().getCharset());
        log.info("timezone=" + serverContext.getTimeZone().getDisplayName());
        log.info("rootDirectory=" + serverContext.getRootDir().getAbsolutePath());
        log.info("temporaryDirectory=" + serverContext.getTemporaryDir().getAbsolutePath());
        log.info("ftpServerAddress=" + serverContext.getCdiFtpAddress());
        StringBuilder sb = new StringBuilder();
        if (serverContext.getTaskServerStoreCodeMap() != null) {
            for (Map.Entry<String, Map<String, CdiProperties.Store>> stringMapEntry : serverContext.getTaskServerStoreCodeMap().entrySet()) {
                sb.append(stringMapEntry).append('\n');
            }
        }
        log.info("ftpUsers=\n" + sb);
        log.info("--------------------------------------------------------------------------------");
        log.info("fieldsNameMap= ");
        if (map != null) {
            map.forEach((task, v) -> {
                log.info(task + " :");
                v.forEach((hanShowField, v1) -> {
                    String dateFormat = StringUtils.isBlank((String)v1.getDateFormat()) ? "" : " : " + v1.getDateFormat();
                    log.info(hanShowField + " : " + v1.getCustomer() + dateFormat);
                });
            });
        }
        log.info("--------------------------------------------------------------------------------");
    }

    public void stop() throws FtpException {
        if (this.ftpServer != null) {
            this.ftpServer.stop();
        }
        this.processor = null;
        this.listener = null;
        if (this.monitor != null) {
            try {
                this.monitor.stop();
            }
            catch (Exception e) {
                log.error("stop local dir monitor error : {}", (Object)e.getMessage(), (Object)e);
                System.exit(-1);
            }
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

