/*
 * Decompiled with CFR 0.152.
 */
package com.hanshow.cdi.config;

import com.hanshow.cdi.core.CdiMode;
import com.hanshow.cdi.core.FileLineSorter;
import com.hanshow.cdi.core.InitializeCdiServer;
import com.hanshow.cdi.properties.CdiProperties;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class SpringBeanConfig {
    @Autowired
    InitializeCdiServer initializeCdiServer;

    @Bean(name={"softFilePoolTaskExecutor"})
    public Executor threadPoolTaskExecutor() {
        for (CdiProperties.Task task : this.initializeCdiServer.getServerContext().getTaskMap().values()) {
            if (!CdiMode.INCREMENT.getName().equals(task.getCdiMode()) && !CdiMode.FIRSTFULL.getName().equals(task.getCdiMode())) continue;
            AtomicInteger SEQUENCE = new AtomicInteger(0);
            ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
            executor.setCorePoolSize(Runtime.getRuntime().availableProcessors());
            executor.setMaxPoolSize(Runtime.getRuntime().availableProcessors());
            executor.setKeepAliveSeconds(0);
            executor.setThreadNamePrefix("soft-file-worker-" + Integer.toString(SEQUENCE.getAndIncrement()));
            executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
            executor.initialize();
            FileLineSorter.softFilePoolTaskExecutor = executor;
            return executor;
        }
        return null;
    }
}

